/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.numbering.EnglishAlphabetNumbering;
import com.itextpdf.kernel.numbering.GreekAlphabetNumbering;
import com.itextpdf.kernel.numbering.RomanNumbering;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.element.List;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.properties.BaseDirection;
import com.itextpdf.layout.properties.IListSymbolFactory;
import com.itextpdf.layout.properties.ListNumberingType;
import com.itextpdf.layout.properties.ListSymbolPosition;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ListItemRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListRenderer
extends BlockRenderer {
    public ListRenderer(List modelElement) {
        super(modelElement);
    }

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        LayoutResult errorResult = this.initializeListSymbols(layoutContext);
        if (errorResult != null) {
            return errorResult;
        }
        LayoutResult result = super.layout(layoutContext);
        if (Boolean.TRUE.equals(this.getPropertyAsBoolean(26)) && null != result.getCauseOfNothing()) {
            if (1 == result.getStatus()) {
                result = this.correctListSplitting(this, null, result.getCauseOfNothing(), result.getOccupiedArea());
            } else if (2 == result.getStatus()) {
                result = this.correctListSplitting(result.getSplitRenderer(), result.getOverflowRenderer(), result.getCauseOfNothing(), result.getOccupiedArea());
            }
        }
        return result;
    }

    @Override
    public IRenderer getNextRenderer() {
        this.logWarningIfGetNextRendererNotOverridden(ListRenderer.class, this.getClass());
        return new ListRenderer((List)this.modelElement);
    }

    @Override
    protected AbstractRenderer createSplitRenderer(int layoutResult) {
        AbstractRenderer splitRenderer = super.createSplitRenderer(layoutResult);
        splitRenderer.addAllProperties(this.getOwnProperties());
        splitRenderer.setProperty(40, Boolean.TRUE);
        return splitRenderer;
    }

    @Override
    protected AbstractRenderer createOverflowRenderer(int layoutResult) {
        AbstractRenderer overflowRenderer = super.createOverflowRenderer(layoutResult);
        overflowRenderer.addAllProperties(this.getOwnProperties());
        overflowRenderer.setProperty(40, Boolean.TRUE);
        return overflowRenderer;
    }

    @Override
    public MinMaxWidth getMinMaxWidth() {
        LayoutResult errorResult = this.initializeListSymbols(new LayoutContext(new LayoutArea(1, new Rectangle(MinMaxWidthUtils.getInfWidth(), 1000000.0f))));
        if (errorResult != null) {
            return MinMaxWidthUtils.countDefaultMinMaxWidth(this);
        }
        return super.getMinMaxWidth();
    }

    protected IRenderer makeListSymbolRenderer(int index, IRenderer renderer) {
        IRenderer symbolRenderer = this.createListSymbolRenderer(index, renderer);
        if (symbolRenderer != null) {
            symbolRenderer.setProperty(74, false);
        }
        return symbolRenderer;
    }

    static Object getListItemOrListProperty(IRenderer listItem, IRenderer list, int propertyId) {
        return listItem.hasProperty(propertyId) ? listItem.getProperty(propertyId) : list.getProperty(propertyId);
    }

    private IRenderer createListSymbolRenderer(int index, IRenderer renderer) {
        Object defaultListSymbol = ListRenderer.getListItemOrListProperty(renderer, this, 37);
        if (defaultListSymbol instanceof Text) {
            return this.surroundTextBullet(new TextRenderer((Text)defaultListSymbol));
        }
        if (defaultListSymbol instanceof Image) {
            return new ImageRenderer((Image)defaultListSymbol);
        }
        if (defaultListSymbol instanceof ListNumberingType) {
            TextRenderer textRenderer;
            String numberText;
            ListNumberingType numberingType = (ListNumberingType)((Object)defaultListSymbol);
            switch (numberingType) {
                case DECIMAL: {
                    numberText = String.valueOf(index);
                    break;
                }
                case DECIMAL_LEADING_ZERO: {
                    numberText = (index < 10 ? "0" : "") + String.valueOf(index);
                    break;
                }
                case ROMAN_LOWER: {
                    numberText = RomanNumbering.toRomanLowerCase(index);
                    break;
                }
                case ROMAN_UPPER: {
                    numberText = RomanNumbering.toRomanUpperCase(index);
                    break;
                }
                case ENGLISH_LOWER: {
                    numberText = EnglishAlphabetNumbering.toLatinAlphabetNumberLowerCase(index);
                    break;
                }
                case ENGLISH_UPPER: {
                    numberText = EnglishAlphabetNumbering.toLatinAlphabetNumberUpperCase(index);
                    break;
                }
                case GREEK_LOWER: {
                    numberText = GreekAlphabetNumbering.toGreekAlphabetNumber(index, false, true);
                    break;
                }
                case GREEK_UPPER: {
                    numberText = GreekAlphabetNumbering.toGreekAlphabetNumber(index, true, true);
                    break;
                }
                case ZAPF_DINGBATS_1: {
                    numberText = TextUtil.charToString((char)(index + 171));
                    break;
                }
                case ZAPF_DINGBATS_2: {
                    numberText = TextUtil.charToString((char)(index + 181));
                    break;
                }
                case ZAPF_DINGBATS_3: {
                    numberText = TextUtil.charToString((char)(index + 191));
                    break;
                }
                case ZAPF_DINGBATS_4: {
                    numberText = TextUtil.charToString((char)(index + 201));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Text textElement = new Text(ListRenderer.getListItemOrListProperty(renderer, this, 41) + numberText + ListRenderer.getListItemOrListProperty(renderer, this, 42));
            if (numberingType == ListNumberingType.GREEK_LOWER || numberingType == ListNumberingType.GREEK_UPPER || numberingType == ListNumberingType.ZAPF_DINGBATS_1 || numberingType == ListNumberingType.ZAPF_DINGBATS_2 || numberingType == ListNumberingType.ZAPF_DINGBATS_3 || numberingType == ListNumberingType.ZAPF_DINGBATS_4) {
                String constantFont = numberingType == ListNumberingType.GREEK_LOWER || numberingType == ListNumberingType.GREEK_UPPER ? "Symbol" : "ZapfDingbats";
                textRenderer = new ConstantFontTextRenderer(textElement, constantFont);
                try {
                    textRenderer.setProperty(20, PdfFontFactory.createFont(constantFont));
                }
                catch (IOException iOException) {}
            } else {
                textRenderer = new TextRenderer(textElement);
            }
            return this.surroundTextBullet(textRenderer);
        }
        if (defaultListSymbol instanceof IListSymbolFactory) {
            return this.surroundTextBullet(((IListSymbolFactory)defaultListSymbol).createSymbol(index, this, renderer).createRendererSubTree());
        }
        if (defaultListSymbol == null) {
            return null;
        }
        throw new IllegalStateException();
    }

    private LineRenderer surroundTextBullet(IRenderer bulletRenderer) {
        LineRenderer lineRenderer = new LineRenderer();
        Text zeroWidthJoiner = new Text("\u200d");
        zeroWidthJoiner.getAccessibilityProperties().setRole("Artifact");
        TextRenderer zeroWidthJoinerRenderer = new TextRenderer(zeroWidthJoiner);
        lineRenderer.addChild(zeroWidthJoinerRenderer);
        lineRenderer.addChild(bulletRenderer);
        lineRenderer.addChild(zeroWidthJoinerRenderer);
        return lineRenderer;
    }

    private LayoutResult correctListSplitting(IRenderer splitRenderer, IRenderer overflowRenderer, IRenderer causeOfNothing, LayoutArea occupiedArea) {
        int firstNotRendered = splitRenderer.getChildRenderers().get(0).getChildRenderers().indexOf(causeOfNothing);
        if (-1 == firstNotRendered) {
            return new LayoutResult(null == overflowRenderer ? 1 : 2, occupiedArea, splitRenderer, overflowRenderer, this);
        }
        IRenderer firstListItemRenderer = splitRenderer.getChildRenderers().get(0);
        ListRenderer newOverflowRenderer = (ListRenderer)this.createOverflowRenderer(2);
        newOverflowRenderer.deleteOwnProperty(26);
        newOverflowRenderer.childRenderers.add(((ListItemRenderer)firstListItemRenderer).createOverflowRenderer(2));
        newOverflowRenderer.childRenderers.addAll(splitRenderer.getChildRenderers().subList(1, splitRenderer.getChildRenderers().size()));
        ArrayList<IRenderer> childrenStillRemainingToRender = new ArrayList<IRenderer>(firstListItemRenderer.getChildRenderers().subList(firstNotRendered + 1, firstListItemRenderer.getChildRenderers().size()));
        splitRenderer.getChildRenderers().removeAll(splitRenderer.getChildRenderers().subList(1, splitRenderer.getChildRenderers().size()));
        if (0 != childrenStillRemainingToRender.size()) {
            newOverflowRenderer.getChildRenderers().get(0).getChildRenderers().addAll(childrenStillRemainingToRender);
            splitRenderer.getChildRenderers().get(0).getChildRenderers().removeAll(childrenStillRemainingToRender);
            newOverflowRenderer.getChildRenderers().get(0).setProperty(44, splitRenderer.getChildRenderers().get(0).getProperty(44));
        } else {
            newOverflowRenderer.childRenderers.remove(0);
        }
        if (null != overflowRenderer) {
            newOverflowRenderer.childRenderers.addAll(overflowRenderer.getChildRenderers());
        }
        if (0 != newOverflowRenderer.childRenderers.size()) {
            return new LayoutResult(2, occupiedArea, splitRenderer, newOverflowRenderer, this);
        }
        return new LayoutResult(1, occupiedArea, null, null, this);
    }

    private LayoutResult initializeListSymbols(LayoutContext layoutContext) {
        if (!this.hasOwnProperty(40)) {
            ArrayList<IRenderer> symbolRenderers = new ArrayList<IRenderer>();
            int listItemNum = this.getProperty(36, 1);
            for (int i = 0; i < this.childRenderers.size(); ++i) {
                boolean listSymbolNotFit;
                ((IRenderer)this.childRenderers.get(i)).setParent(this);
                listItemNum = ((IRenderer)this.childRenderers.get(i)).getProperty(120) != null ? (Integer)((IRenderer)this.childRenderers.get(i)).getProperty(120) : listItemNum;
                IRenderer currentSymbolRenderer = this.makeListSymbolRenderer(listItemNum, (IRenderer)this.childRenderers.get(i));
                if (BaseDirection.RIGHT_TO_LEFT.equals(this.getProperty(7))) {
                    currentSymbolRenderer.setProperty(7, (Object)BaseDirection.RIGHT_TO_LEFT);
                }
                LayoutResult listSymbolLayoutResult = null;
                if (currentSymbolRenderer != null) {
                    ++listItemNum;
                    currentSymbolRenderer.setParent((IRenderer)this.childRenderers.get(i));
                    listSymbolLayoutResult = currentSymbolRenderer.layout(layoutContext);
                    currentSymbolRenderer.setParent(null);
                }
                ((IRenderer)this.childRenderers.get(i)).setParent(null);
                boolean isForcedPlacement = Boolean.TRUE.equals(this.getPropertyAsBoolean(26));
                boolean bl = listSymbolNotFit = listSymbolLayoutResult != null && listSymbolLayoutResult.getStatus() != 1;
                if (listSymbolNotFit && isForcedPlacement) {
                    currentSymbolRenderer = null;
                }
                symbolRenderers.add(currentSymbolRenderer);
                if (!listSymbolNotFit || isForcedPlacement) continue;
                return new LayoutResult(3, null, null, this, listSymbolLayoutResult.getCauseOfNothing());
            }
            float maxSymbolWidth = 0.0f;
            for (int i = 0; i < this.childRenderers.size(); ++i) {
                IRenderer listItemRenderer;
                IRenderer symbolRenderer = (IRenderer)symbolRenderers.get(i);
                if (symbolRenderer == null || (ListSymbolPosition)((Object)ListRenderer.getListItemOrListProperty(listItemRenderer = (IRenderer)this.childRenderers.get(i), this, 83)) == ListSymbolPosition.INSIDE) continue;
                maxSymbolWidth = Math.max(maxSymbolWidth, symbolRenderer.getOccupiedArea().getBBox().getWidth());
            }
            Float symbolIndent = this.getPropertyAsFloat(39);
            listItemNum = 0;
            for (IRenderer childRenderer : this.childRenderers) {
                LayoutTaggingHelper taggingHelper;
                childRenderer.setParent(this);
                boolean isRtl = BaseDirection.RIGHT_TO_LEFT == childRenderer.getProperty(7);
                int marginToSet = isRtl ? 45 : 44;
                childRenderer.deleteOwnProperty(marginToSet);
                UnitValue marginToSetUV = childRenderer.getProperty(marginToSet, UnitValue.createPointValue(0.0f));
                if (!marginToSetUV.isPointValue()) {
                    Logger logger = LoggerFactory.getLogger(ListRenderer.class);
                    logger.error(MessageFormatUtil.format("Property {0} in percents is not supported", marginToSet));
                }
                float calculatedMargin = marginToSetUV.getValue();
                if ((ListSymbolPosition)((Object)ListRenderer.getListItemOrListProperty(childRenderer, this, 83)) == ListSymbolPosition.DEFAULT) {
                    calculatedMargin += maxSymbolWidth + (symbolIndent != null ? symbolIndent.floatValue() : 0.0f);
                }
                childRenderer.setProperty(marginToSet, UnitValue.createPointValue(calculatedMargin));
                IRenderer symbolRenderer = (IRenderer)symbolRenderers.get(listItemNum++);
                ((ListItemRenderer)childRenderer).addSymbolRenderer(symbolRenderer, maxSymbolWidth);
                if (symbolRenderer == null || (taggingHelper = (LayoutTaggingHelper)this.getProperty(108)) == null) continue;
                if (symbolRenderer instanceof LineRenderer) {
                    taggingHelper.setRoleHint(symbolRenderer.getChildRenderers().get(1), "Lbl");
                    continue;
                }
                taggingHelper.setRoleHint(symbolRenderer, "Lbl");
            }
        }
        return null;
    }

    private static final class ConstantFontTextRenderer
    extends TextRenderer {
        private String constantFontName;

        public ConstantFontTextRenderer(Text textElement, String font) {
            super(textElement);
            this.constantFontName = font;
        }

        @Override
        public void draw(DrawContext drawContext) {
            try {
                this.setProperty(20, PdfFontFactory.createFont(this.constantFontName));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            super.draw(drawContext);
        }
    }
}

