/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.borders;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;

public class SolidBorder
extends Border {
    public SolidBorder(float width) {
        super(width);
    }

    public SolidBorder(Color color, float width) {
        super(color, width);
    }

    public SolidBorder(Color color, float width, float opacity) {
        super(color, width, opacity);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, Border.Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        float x3 = 0.0f;
        float y3 = 0.0f;
        float x4 = 0.0f;
        float y4 = 0.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2, defaultSide);
        switch (borderSide) {
            case TOP: {
                x3 = x2 + borderWidthAfter;
                y3 = y2 + this.width;
                x4 = x1 - borderWidthBefore;
                y4 = y1 + this.width;
                break;
            }
            case RIGHT: {
                x3 = x2 + this.width;
                y3 = y2 - borderWidthAfter;
                x4 = x1 + this.width;
                y4 = y1 + borderWidthBefore;
                break;
            }
            case BOTTOM: {
                x3 = x2 - borderWidthAfter;
                y3 = y2 - this.width;
                x4 = x1 + borderWidthBefore;
                y4 = y1 - this.width;
                break;
            }
            case LEFT: {
                x3 = x2 - this.width;
                y3 = y2 + borderWidthAfter;
                x4 = x1 - this.width;
                y4 = y1 - borderWidthBefore;
            }
        }
        canvas.saveState().setFillColor(this.transparentColor.getColor());
        this.transparentColor.applyFillTransparency(canvas);
        canvas.moveTo(x1, y1).lineTo(x2, y2).lineTo(x3, y3).lineTo(x4, y4).lineTo(x1, y1).fill().restoreState();
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float horizontalRadius1, float verticalRadius1, float horizontalRadius2, float verticalRadius2, Border.Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        float x3 = 0.0f;
        float y3 = 0.0f;
        float x4 = 0.0f;
        float y4 = 0.0f;
        Border.Side borderSide = this.getBorderSide(x1, y1, x2, y2, defaultSide);
        switch (borderSide) {
            case TOP: {
                x3 = x2 + borderWidthAfter;
                y3 = y2 + this.width;
                x4 = x1 - borderWidthBefore;
                y4 = y1 + this.width;
                float innerRadiusBefore = Math.max(0.0f, horizontalRadius1 - borderWidthBefore);
                float innerRadiusFirst = Math.max(0.0f, verticalRadius1 - this.width);
                float innerRadiusSecond = Math.max(0.0f, verticalRadius2 - this.width);
                float innerRadiusAfter = Math.max(0.0f, horizontalRadius2 - borderWidthAfter);
                if (innerRadiusBefore > innerRadiusFirst) {
                    x1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x4, y1 - innerRadiusFirst), new Point(x1 + innerRadiusBefore, y1 - innerRadiusFirst)).getX();
                    y1 -= innerRadiusFirst;
                } else if (0.0f != innerRadiusBefore && 0.0f != innerRadiusFirst) {
                    y1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1 + innerRadiusBefore, y1), new Point(x1 + innerRadiusBefore, y1 - innerRadiusFirst)).getY();
                    x1 += innerRadiusBefore;
                }
                if (innerRadiusAfter > innerRadiusSecond) {
                    x2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2, y2 - innerRadiusSecond), new Point(x2 - innerRadiusAfter, y2 - innerRadiusSecond)).getX();
                    y2 -= innerRadiusSecond;
                    break;
                }
                if (0.0f == innerRadiusAfter || 0.0f == innerRadiusSecond) break;
                y2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2 - innerRadiusAfter, y2), new Point(x2 - innerRadiusAfter, y2 - innerRadiusSecond)).getY();
                x2 -= innerRadiusAfter;
                break;
            }
            case RIGHT: {
                x3 = x2 + this.width;
                y3 = y2 - borderWidthAfter;
                x4 = x1 + this.width;
                y4 = y1 + borderWidthBefore;
                float innerRadiusBefore = Math.max(0.0f, verticalRadius1 - borderWidthBefore);
                float innerRadiusFirst = Math.max(0.0f, horizontalRadius1 - this.width);
                float innerRadiusSecond = Math.max(0.0f, horizontalRadius2 - this.width);
                float innerRadiusAfter = Math.max(0.0f, verticalRadius2 - borderWidthAfter);
                if (innerRadiusFirst > innerRadiusBefore) {
                    x1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1, y1 - innerRadiusBefore), new Point(x1 - innerRadiusFirst, y1 - innerRadiusBefore)).getX();
                    y1 -= innerRadiusBefore;
                } else if (0.0f != innerRadiusBefore && 0.0f != innerRadiusFirst) {
                    y1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1 - innerRadiusFirst, y1), new Point(x1 - innerRadiusFirst, y1 - innerRadiusBefore)).getY();
                    x1 -= innerRadiusFirst;
                }
                if (innerRadiusAfter > innerRadiusSecond) {
                    y2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2 - innerRadiusSecond, y2), new Point(x2 - innerRadiusSecond, y2 + innerRadiusAfter)).getY();
                    x2 -= innerRadiusSecond;
                    break;
                }
                if (0.0f == innerRadiusAfter || 0.0f == innerRadiusSecond) break;
                x2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2, y2 + innerRadiusAfter), new Point(x2 - innerRadiusSecond, y2 + innerRadiusAfter)).getX();
                y2 += innerRadiusAfter;
                break;
            }
            case BOTTOM: {
                x3 = x2 - borderWidthAfter;
                y3 = y2 - this.width;
                x4 = x1 + borderWidthBefore;
                y4 = y1 - this.width;
                float innerRadiusBefore = Math.max(0.0f, horizontalRadius1 - borderWidthBefore);
                float innerRadiusFirst = Math.max(0.0f, verticalRadius1 - this.width);
                float innerRadiusSecond = Math.max(0.0f, verticalRadius2 - this.width);
                float innerRadiusAfter = Math.max(0.0f, horizontalRadius2 - borderWidthAfter);
                if (innerRadiusFirst > innerRadiusBefore) {
                    y1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1 - innerRadiusBefore, y1), new Point(x1 - innerRadiusBefore, y1 + innerRadiusFirst)).getY();
                    x1 -= innerRadiusBefore;
                } else if (0.0f != innerRadiusBefore && 0.0f != innerRadiusFirst) {
                    x1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1, y1 + innerRadiusFirst), new Point(x1 - innerRadiusBefore, y1 + innerRadiusFirst)).getX();
                    y1 += innerRadiusFirst;
                }
                if (innerRadiusAfter > innerRadiusSecond) {
                    x2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2, y2 + innerRadiusSecond), new Point(x2 + innerRadiusAfter, y2 + innerRadiusSecond)).getX();
                    y2 += innerRadiusSecond;
                    break;
                }
                if (0.0f == innerRadiusAfter || 0.0f == innerRadiusSecond) break;
                y2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2 + innerRadiusAfter, y2), new Point(x2 + innerRadiusAfter, y2 + innerRadiusSecond)).getY();
                x2 += innerRadiusAfter;
                break;
            }
            case LEFT: {
                x3 = x2 - this.width;
                y3 = y2 + borderWidthAfter;
                x4 = x1 - this.width;
                y4 = y1 - borderWidthBefore;
                float innerRadiusBefore = Math.max(0.0f, verticalRadius1 - borderWidthBefore);
                float innerRadiusFirst = Math.max(0.0f, horizontalRadius1 - this.width);
                float innerRadiusSecond = Math.max(0.0f, horizontalRadius2 - this.width);
                float innerRadiusAfter = Math.max(0.0f, verticalRadius2 - borderWidthAfter);
                if (innerRadiusFirst > innerRadiusBefore) {
                    x1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1, y1 + innerRadiusBefore), new Point(x1 + innerRadiusFirst, y1 + innerRadiusBefore)).getX();
                    y1 += innerRadiusBefore;
                } else if (0.0f != innerRadiusBefore && 0.0f != innerRadiusFirst) {
                    y1 = (float)this.getIntersectionPoint(new Point(x1, y1), new Point(x4, y4), new Point(x1 + innerRadiusFirst, y1), new Point(x1 + innerRadiusFirst, y1 + innerRadiusBefore)).getY();
                    x1 += innerRadiusFirst;
                }
                if (innerRadiusAfter > innerRadiusSecond) {
                    y2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2 + innerRadiusSecond, y2), new Point(x2 + innerRadiusSecond, y2 - innerRadiusAfter)).getY();
                    x2 += innerRadiusSecond;
                    break;
                }
                if (0.0f == innerRadiusAfter || 0.0f == innerRadiusSecond) break;
                x2 = (float)this.getIntersectionPoint(new Point(x2, y2), new Point(x3, y3), new Point(x2, y2 - innerRadiusAfter), new Point(x2 + innerRadiusSecond, y2 - innerRadiusAfter)).getX();
                y2 -= innerRadiusAfter;
            }
        }
        canvas.saveState().setFillColor(this.transparentColor.getColor());
        this.transparentColor.applyFillTransparency(canvas);
        canvas.moveTo(x1, y1).lineTo(x2, y2).lineTo(x3, y3).lineTo(x4, y4).lineTo(x1, y1).fill().restoreState();
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2, Border.Side defaultSide) {
        canvas.saveState().setStrokeColor(this.transparentColor.getColor());
        this.transparentColor.applyStrokeTransparency(canvas);
        canvas.setLineWidth(this.width).moveTo(x1, y1).lineTo(x2, y2).stroke().restoreState();
    }
}

