/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.kernel.pdf.EncryptionProperties;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.kernel.pdf.WriterProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.util.Map;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipient;

public final class PdfEncryptor {
    private IMetaInfo metaInfo;
    private EncryptionProperties properties;

    public static void encrypt(PdfReader reader, OutputStream os, EncryptionProperties properties, Map<String, String> newInfo) {
        new PdfEncryptor().setEncryptionProperties(properties).encrypt(reader, os, newInfo);
    }

    public static void encrypt(PdfReader reader, OutputStream os, EncryptionProperties properties) {
        PdfEncryptor.encrypt(reader, os, properties, null);
    }

    public static String getPermissionsVerbose(int permissions) {
        StringBuilder buf = new StringBuilder("Allowed:");
        if ((0x804 & permissions) == 2052) {
            buf.append(" Printing");
        }
        if ((8 & permissions) == 8) {
            buf.append(" Modify contents");
        }
        if ((0x10 & permissions) == 16) {
            buf.append(" Copy");
        }
        if ((0x20 & permissions) == 32) {
            buf.append(" Modify annotations");
        }
        if ((0x100 & permissions) == 256) {
            buf.append(" Fill in");
        }
        if ((0x200 & permissions) == 512) {
            buf.append(" Screen readers");
        }
        if ((0x400 & permissions) == 1024) {
            buf.append(" Assembly");
        }
        if ((4 & permissions) == 4) {
            buf.append(" Degraded printing");
        }
        return buf.toString();
    }

    public static boolean isPrintingAllowed(int permissions) {
        return (0x804 & permissions) == 2052;
    }

    public static boolean isModifyContentsAllowed(int permissions) {
        return (8 & permissions) == 8;
    }

    public static boolean isCopyAllowed(int permissions) {
        return (0x10 & permissions) == 16;
    }

    public static boolean isModifyAnnotationsAllowed(int permissions) {
        return (0x20 & permissions) == 32;
    }

    public static boolean isFillInAllowed(int permissions) {
        return (0x100 & permissions) == 256;
    }

    public static boolean isScreenReadersAllowed(int permissions) {
        return (0x200 & permissions) == 512;
    }

    public static boolean isAssemblyAllowed(int permissions) {
        return (0x400 & permissions) == 1024;
    }

    public static boolean isDegradedPrintingAllowed(int permissions) {
        return (4 & permissions) == 4;
    }

    public static byte[] getContent(RecipientInformation recipientInfo, PrivateKey certificateKey, String certificateKeyProvider) throws CMSException {
        JceKeyTransRecipient jceKeyTransRecipient = new JceKeyTransEnvelopedRecipient(certificateKey).setProvider(certificateKeyProvider);
        return recipientInfo.getContent(jceKeyTransRecipient);
    }

    public PdfEncryptor setEventCountingMetaInfo(IMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
        return this;
    }

    public PdfEncryptor setEncryptionProperties(EncryptionProperties properties) {
        this.properties = properties;
        return this;
    }

    public void encrypt(PdfReader reader, OutputStream os, Map<String, String> newInfo) {
        WriterProperties writerProperties = new WriterProperties();
        writerProperties.encryptionProperties = this.properties;
        StampingProperties stampingProperties = new StampingProperties();
        stampingProperties.setEventCountingMetaInfo(this.metaInfo);
        try (PdfWriter writer = new PdfWriter(os, writerProperties);
             PdfDocument document = new PdfDocument(reader, writer, stampingProperties);){
            document.getDocumentInfo().setMoreInfo(newInfo);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void encrypt(PdfReader reader, OutputStream os) {
        this.encrypt(reader, os, null);
    }
}

