/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.otf.ContextualPositionRule;
import com.itextpdf.io.font.otf.ContextualTable;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.font.otf.OpenTableLookup;
import com.itextpdf.io.font.otf.OpenTypeFontTableReader;
import com.itextpdf.io.font.otf.OtfClass;
import com.itextpdf.io.font.otf.PosLookupRecord;
import com.itextpdf.io.font.otf.lookuptype7.PosTableLookup7Format2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GposLookupType7
extends OpenTableLookup {
    private static final Logger LOGGER = LoggerFactory.getLogger(GposLookupType7.class);
    protected List<ContextualTable<ContextualPositionRule>> subTables = new ArrayList<ContextualTable<ContextualPositionRule>>();

    public GposLookupType7(OpenTypeFontTableReader openReader, int lookupFlag, int[] subTableLocations) throws IOException {
        super(openReader, lookupFlag, subTableLocations);
        this.readSubTables();
    }

    @Override
    public boolean transformOne(GlyphLine line) {
        boolean changed = false;
        int oldLineStart = line.start;
        int oldLineEnd = line.end;
        int initialLineIndex = line.idx;
        for (ContextualTable<ContextualPositionRule> subTable : this.subTables) {
            ContextualPositionRule contextRule = subTable.getMatchingContextRule(line);
            if (contextRule == null) continue;
            int lineEndBeforeTransformations = line.end;
            PosLookupRecord[] posLookupRecords = contextRule.getPosLookupRecords();
            OpenTableLookup.GlyphIndexer gidx = new OpenTableLookup.GlyphIndexer();
            gidx.line = line;
            for (PosLookupRecord posRecord : posLookupRecords) {
                gidx.idx = initialLineIndex;
                for (int i = 0; i < posRecord.sequenceIndex; ++i) {
                    gidx.nextGlyph(this.openReader, this.lookupFlag);
                }
                line.idx = gidx.idx;
                OpenTableLookup lookupTable = this.openReader.getLookupTable(posRecord.lookupListIndex);
                changed = lookupTable.transformOne(line) || changed;
            }
            line.idx = line.end;
            line.start = oldLineStart;
            int lenDelta = lineEndBeforeTransformations - line.end;
            line.end = oldLineEnd - lenDelta;
            return changed;
        }
        ++line.idx;
        return changed;
    }

    @Override
    protected void readSubTable(int subTableLocation) throws IOException {
        this.openReader.rf.seek(subTableLocation);
        short substFormat = this.openReader.rf.readShort();
        switch (substFormat) {
            case 2: {
                this.readSubTableFormat2(subTableLocation);
                break;
            }
            case 1: 
            case 3: {
                LOGGER.warn(MessageFormatUtil.format("Subtable format {0} of GPOS Lookup Type {1} is not supported yet", substFormat, 7));
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad subtable format identifier: " + substFormat);
            }
        }
    }

    protected void readSubTableFormat2(int subTableLocation) throws IOException {
        int coverageOffset = this.openReader.rf.readUnsignedShort();
        int classDefOffset = this.openReader.rf.readUnsignedShort();
        int posClassSetCount = this.openReader.rf.readUnsignedShort();
        int[] posClassSetOffsets = this.openReader.readUShortArray(posClassSetCount, subTableLocation);
        HashSet<Integer> coverageGlyphIds = new HashSet<Integer>(this.openReader.readCoverageFormat(subTableLocation + coverageOffset));
        OtfClass classDefinition = this.openReader.readClassDefinition(subTableLocation + classDefOffset);
        PosTableLookup7Format2 t = new PosTableLookup7Format2(this.openReader, this.lookupFlag, coverageGlyphIds, classDefinition);
        ArrayList<List<ContextualPositionRule>> subClassSets = new ArrayList<List<ContextualPositionRule>>(posClassSetCount);
        for (int i = 0; i < posClassSetCount; ++i) {
            ArrayList<PosTableLookup7Format2.PosRuleFormat2> subClassSet = null;
            if (posClassSetOffsets[i] != 0) {
                this.openReader.rf.seek(posClassSetOffsets[i]);
                int posClassRuleCount = this.openReader.rf.readUnsignedShort();
                int[] posClassRuleOffsets = this.openReader.readUShortArray(posClassRuleCount, posClassSetOffsets[i]);
                subClassSet = new ArrayList<PosTableLookup7Format2.PosRuleFormat2>(posClassRuleCount);
                for (int j = 0; j < posClassRuleCount; ++j) {
                    this.openReader.rf.seek(posClassRuleOffsets[j]);
                    int glyphCount = this.openReader.rf.readUnsignedShort();
                    int posCount = this.openReader.rf.readUnsignedShort();
                    int[] inputClassIds = this.openReader.readUShortArray(glyphCount - 1);
                    PosLookupRecord[] posLookupRecords = this.openReader.readPosLookupRecords(posCount);
                    PosTableLookup7Format2.PosRuleFormat2 rule = new PosTableLookup7Format2.PosRuleFormat2(t, inputClassIds, posLookupRecords);
                    subClassSet.add(rule);
                }
            }
            subClassSets.add(subClassSet);
        }
        t.setPosClassSets(subClassSets);
        this.subTables.add(t);
    }
}

