/*
 * Decompiled with CFR 0.152.
 */
package xsatriya.xsf.npnu;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBody;
import xsatriya.db.connDb;
import xsatriya.docx.XSDocxAkta;
import xsatriya.help.XSHelp;
import xsatriya.xsf.Db;
import xsatriya.xsf.Help;

public class Akta {
    connDb koneksi = new connDb();
    XSDocxAkta docx = new XSDocxAkta();
    XSHelp xhelp = new XSHelp();
    Db db = new Db();
    Help help = new Help();
    String dbname = this.db.dbname();
    String[][] saksi = new String[][]{{"FAZRUL MUHARAMSYAH", "Tuan FAZRUL MUHARAMSYAH", "lahir di Tasikmalaya, pada tanggal 29-06-1993 (dua puluh sembilan Juni seribu sembilan ratus sembilan puluh tiga), Warga Negara Indonesia, Karyawan Swasta, bertempat tinggal di Kota Bogor, Jalan Puspalangka Blok W 8/17, Rukun Tetangga 003, Rukun Warga 009, Kelurahan Kedungwaringin, Kecamatan Tanah Sereal, Kota Bogor, Pemegang Kartu Tanda Penduduk Nomor : 3271062906930013"}, {"MUHAMAD AKBAR FADILAH", "Tuan MUHAMAD AKBAR FADILAH", "lahir di Bogor, pada tanggal 11-02-2003 (sebelas Februari dua ribu tiga), Warga Negara Indonesia, bertempat tinggal di Provinsi Jawa Barat, Kampung Setu Uncal, Rukun Tetangga 005, Rukun Warga 007, Desa Purwasari,Kecamatan Dramaga, Kabupaten Bogor, Pemegang Kartu Tanda Penduduk Nomor : 3201301102030003"}};

    public static void main(String[] args) throws ClassNotFoundException, IOException, InvalidFormatException, Exception {
        System.out.println("XSatriya");
    }

    public String NotarisConvert(String nmfolder, String lokf, String ida, String[] pemberi, String[] debitur, String[] penerima, String[][] jumlahObyek, String[][] listObyek, String ktgrprint) throws ClassNotFoundException, IOException, InvalidFormatException, Exception {
        long margin_left = 660L;
        long margin_top = 1010L;
        long margin_right = 620L;
        long margin_bottom = 1010L;
        long margin_footer = 0L;
        int spacing_before = 0;
        int spacing_after = 0;
        double spacing_between = 1.7;
        double bataskanan = 7.4;
        String rgb = "merah";
        String font_name = "Courier New";
        int font_size = 12;
        String footer_font_name = "Times New Roman";
        int footer_font_size = 12;
        boolean tabel_spacing_before = false;
        boolean tabel_spacing_after = false;
        double tabel_spacing_between = 1.7;
        XWPFDocument document = new XWPFDocument();
        CTBody body = this.docx.NotPagesizeMargin(document, margin_left, margin_top, margin_right, margin_bottom, margin_footer);
        document.getProperties().getCoreProperties().setCreator("XSatriya");
        document.getProperties().getCoreProperties().setKeywords("XSatriya");
        document.getProperties().getCoreProperties().setTitle("Akta Fidusia");
        document.getProperties().getCoreProperties().setDescription("Akta Fidusia");
        int batas = 84;
        int ind0 = 400;
        String pi0 = "-";
        String minleft = "----------------------- ";
        String fjam = "";
        String kuasatgl = "";
        String fjanji = "";
        String fjanjino = "";
        String fjanjitgl = "";
        String fhutang = "";
        String fhutang3 = "";
        String fjaminan = "";
        String fjaminan3 = "";
        String saksi1 = "";
        String saksi2 = "";
        String fno = penerima[1];
        String ftgl = penerima[2];
        fjam = penerima[3];
        kuasatgl = penerima[19];
        String[] kuasatg = this.xhelp.ConvertYMDtoDMY(kuasatgl, "-");
        String fpemberiktgr = pemberi[1];
        String fpemberipanggil = pemberi[4];
        String fpemberinama = pemberi[5];
        String fpemberibadannama = pemberi[40];
        String fdebiturnama = debitur[3];
        fjanji = penerima[6];
        fjanji = fjanji.replace("_", " ");
        fjanjino = penerima[7];
        fjanjitgl = penerima[8];
        String[] fjanjitg = this.xhelp.ConvertYMDtoDMY(fjanjitgl, "-");
        String bank = penerima[4];
        String bankcabang = penerima[5];
        fhutang = penerima[13];
        fhutang3 = this.help.terbilangUang(fhutang);
        fjaminan = penerima[12];
        fjaminan3 = this.help.terbilangUang(fjaminan);
        String ktgr = ktgrprint.equals("salinan") ? "garis" : "nogaris";
        this.judulAkta(document, spacing_before, spacing_after, spacing_between, bataskanan, "nogaris", rgb, font_name, font_size, fno);
        this.waktuAkta(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, ktgrprint, ftgl, fjam);
        XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("-Hadir dihadapan saya, ");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText("PUTRANTO NUR UTOMO, Sarjana Hukum, Magister Kenotariatan, ");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Notaris di ");
        run.setText("Kota Bogor, dengan dihadiri oleh saksi-saksi yang telah saya, Notaris kenal dan nama-namanya akan disebutkan pada bagian akhir akta ini :");
        run.addTab();
        this.Penghadap(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, bank, bankcabang, pemberi, kuasatg);
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("-Para penghadap dikenal oleh saya, Notaris. ");
        run.addTab();
        run.addBreak();
        run.setText("-Para penghadap dengan bertindak dalam kedudukannya tersebut menerangkan terlebih dahulu: ");
        run.addTab();
        if (!bank.equals("PT. SGMW MULTIFINANCE INDONESIA") && !bank.equals("PT. SGMW MULTIFINANCE INDONESIA DAN PT. BANK SINARMAS TBK")) {
            fjanji = "Perjanjian Kredit";
        }
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("A. Bahwa, berdasarkan " + fjanji + ", ");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Nomor ");
        run.setText(String.valueOf(fjanjino) + ", ");
        run.setText("tertanggal " + fjanjitg[0] + "-" + fjanjitg[1] + "-" + fjanjitg[2] + " (" + this.xhelp.terbilangTgl(fjanjitg[0], fjanjitg[1], fjanjitg[2]) + "), ");
        run.setText("yang dibuat dibawah tangan dan bermaterai cukup.");
        run.addTab();
        run.addBreak();
        run.setText("Yang surat aslinya diperlihatkan kepada saya dan penambahan, perubahan, perpanjangan serta ");
        run.addTab();
        run.addBreak();
        run.setText("pembaharuannya yang mungkin diadakan kemudian, diatur mengenai pemberian fasilitas kredit sampai dengan jumlah ");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText(String.valueOf(this.xhelp.formatRp(Double.parseDouble(fhutang))) + " (" + fhutang3 + "), ");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("dari Penerima Fidusia/Kreditur kepada Pemberi Fidusia/Debitur Perjanjian tersebut berikut perubahan, penambahan, perpanjangan dan penegasannya.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("- untuk selanjutnya disebut ");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText("Perjanjian Kredit");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText(". ");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("B. Bahwa, untuk lebih menjamin terbayarnya dengan ");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Baik segala sesuatu yang terhutang dan harus Dibayar oleh Pemberi Fidusia kepada Penerima Fidusia baik hutang kepada Penerima Fidusia baik hutang pokok, bunga dan biaya-biaya lainnya yang timbul berdasarkan Perjanjian Kredit, Pemberi Fidusia diwajibkan untuk memberikan jaminan secara fidusia atas Piutang Jual Beli.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("C. Bahwa, untuk memenuhi ketentuan tentang ");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Pemberian jaminan yang ditentukan dalam Perjanjian Kredit, maka Pemberi Fidusia dan Penerima Fidusia, telah sepakat untuk mengadakan perjanjian sebagaimana yang dimaksud dalam Undang-undang Nomor 42 Tahun 1999 (seribu sembilan ratus sembilan puluh sembilan), tentang Jaminan Fidusia beserta segala peraturan-peraturan pelaksanaannya (\u201c");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText("Undang-Undang Fidusia");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("\u201d).");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("-Selanjutnya, oleh karena hal tersebut diatas dan berdasarkan pada perjanjian yang telah disepakati bersama, Pemberi Fidusia dan Penerima Fidusia adengan ini mengikatkan diri pada Akta Jaminan Fidusia ini dengan menyepakati hal-hal sebagai berikut : ");
        run.addTab();
        String bpkbnm = "";
        bpkbnm = fdebiturnama == null || fdebiturnama.equals("") ? fpemberinama : fdebiturnama;
        this.PasalBPRBP(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, bank, bankcabang, bpkbnm, pemberi, listObyek);
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Akta ini diselesaikan pukul ");
        int itv = 5;
        SimpleDateFormat dateFormat = new SimpleDateFormat("hh:mm");
        Date dat = dateFormat.parse(fjam);
        SimpleDateFormat dateFormat24 = new SimpleDateFormat("HH:mm");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dat);
        calendar.add(12, itv);
        String jams = dateFormat24.format(calendar.getTime());
        String sjam = "";
        String smenit = "";
        String stmenit = "";
        if (!jams.equals("")) {
            smenit = jams.substring(3, 5);
            sjam = jams.substring(0, 2);
        } else {
            sjam = "00";
            smenit = "00";
        }
        stmenit = smenit.equals("00") ? "" : "lewat " + this.xhelp.terbilang(smenit).trim() + " menit";
        if (!sjam.equals("00")) {
            run.setText(String.valueOf(sjam) + "." + smenit + " WIB (" + this.xhelp.terbilang(sjam) + stmenit + " Waktu Indonesia bagian Barat).");
            run.addTab();
        } else {
            run.setText(" ");
        }
        run.addBreak();
        run.setText("Para Penghadap saya, Notaris kenal.");
        run.addTab();
        saksi1 = penerima[17];
        saksi2 = penerima[18];
        this.AkhirAkta(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, saksi1, saksi2);
        this.TTDAkta(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, ktgrprint, saksi1, saksi2, bank, bankcabang);
        this.docx.footer(document, footer_font_name, footer_font_size);
        String hsl = "";
        String fname = "";
        fname = !fno.equals("") ? String.valueOf(ftgl) + "-" + fno + "-" + fpemberinama : String.valueOf(ida) + "-" + fpemberinama;
        hsl = this.help.lokFile(document, lokf, nmfolder, fname);
        this.db.convertok(nmfolder, ida, hsl, ktgrprint);
        return hsl;
    }

    public void judulAkta(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String fno) {
        XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "tengah", 0, ktgr, rgb);
        XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText("AKTA JAMINAN FIDUSIA");
        run.addBreak();
        if (!fno.equals("")) {
            run.setText("Nomor : " + fno + ".-");
        } else {
            run.setText("Nomor : ");
        }
        run.addBreak();
    }

    public void waktuAkta(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String ktgrprint, String tgl, String jam) throws ClassNotFoundException, IOException, InvalidFormatException, Exception {
        XWPFRun run;
        XWPFParagraph paragraph;
        String fhari = "";
        String fmenit = "";
        String tfmenit = "";
        if (!tgl.equals("")) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            int ifhari = formatter.parse(tgl).getDay();
            fhari = this.xhelp.AngkaHari(Integer.toString(ifhari));
            String[] tg = this.xhelp.ConvertYMDtoDMY(tgl, "-");
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("-Pada hari ini, " + fhari + ", tanggal (" + tg[0] + "-" + tg[1] + "-" + tg[2] + ") " + this.xhelp.terbilangTgl(tg[0], tg[1], tg[2]) + ".");
            run.addTab();
            run.addBreak();
        } else {
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "left", 0, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("-Pada hari ini,");
            run.addBreak();
            run.setText("tanggal ");
            run.addBreak();
        }
        if (!jam.equals("")) {
            fmenit = jam.substring(3, 5);
            jam = jam.substring(0, 2);
        } else {
            jam = "00";
            fmenit = "00";
        }
        tfmenit = fmenit.equals("00") ? "" : "lewat " + this.xhelp.terbilang(fmenit).trim() + " menit";
        if (!jam.equals("00")) {
            run.setText("-Pukul " + jam + "." + fmenit + " WIB (" + this.xhelp.terbilang(jam) + tfmenit + " Waktu Indonesia bagian Barat).");
            run.addTab();
        } else {
            run.setText("-Pukul ");
        }
        if (ktgrprint.equals("salinan")) {
            this.docx.createLineShape(paragraph, "atas:-18", "#FF0000");
            this.docx.createLineShape(paragraph, "atas:-15", "#FF0000");
        }
    }

    public String UraianJumlahObyek(String[][] jumlahObyek) {
        String[][] arr0 = jumlahObyek;
        String obyjml = "";
        String obyjml0 = "";
        String dan = "";
        if (arr0.length != 0) {
            if (arr0.length == 1) {
                obyjml = String.valueOf(arr0[0][1]) + " (" + this.xhelp.terbilang(arr0[0][1]).trim() + ") unit " + arr0[0][0].replace("_", " ");
            } else {
                int ir0 = 0;
                while (ir0 < arr0.length) {
                    if (arr0[ir0][0] != null) {
                        dan = ir0 == 0 ? "" : " dan ";
                    }
                    if (arr0[ir0][0] == null) {
                        dan = "";
                        break;
                    }
                    obyjml0 = String.valueOf(dan) + arr0[ir0][1] + " (" + this.xhelp.terbilang(arr0[ir0][1]).trim() + ") unit " + arr0[ir0][0].replace("_", " ");
                    obyjml = String.valueOf(obyjml) + obyjml0;
                    ++ir0;
                }
            }
        }
        return obyjml;
    }

    public void Penghadap(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String bank, String cabang, String[] pemberi, String[] kuasatg) {
        if (bank.equals("PT. BANK PEREKONOMIAN RAKYAT BANTORU PERINTIS")) {
            XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
            XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("-");
            run.setText("Nona ");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setBold(true);
            run.setText("LYNDA ULIASI PARDEDE");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(", lahir di Jakarta, pada tanggal 29-03-1974 (dua puluh sembilan Maret seribu sembilan ratus tujuh puluh empat), Pemimpin Kantor Cabang Depok dari Perseroan Terbatas ");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setBold(true);
            run.setText("PT. BANK PEREKONOMIAN RAKYAT BANTORU PERINTIS");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(", berkedudukan di Kota Depok, bertempat tinggal di Propinsi Daerah Khusus Ibukota Jakarta, Jalan Pepaya II Nomor 69, Rukun Tetangga 002, Rukun Warga 005, Kelurahan Jagakarsa, Kecamatan Jagakarsa, Jakarta Selatan, pemegang Kartu Tanda Penduduk Nomor : ");
            run.addTab();
            run.addBreak();
            run.setText("3175050910830008, Warga Negara Indonesia;");
            run.addTab();
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("a. Selaku Kuasa untuk dan atas nama : ");
            run.addTab();
            this.PemberiFidusia(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, bank, cabang, pemberi);
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("Berdasarkan Surat Kuasa tertanggal ");
            run.setText(String.valueOf(kuasatg[0]) + "-" + kuasatg[1] + "-" + kuasatg[2] + " ");
            run.addTab();
            run.addBreak();
            run.setText("(" + this.xhelp.terbilangTgl(kuasatg[0], kuasatg[1], kuasatg[2]) + "), ");
            run.setText("yang dibuat dibawah tangan, bermeterai cukup.");
            run.addTab();
            run.addBreak();
            run.setText("- Untuk selanjutnya dalam akta ini disebut :");
            run.addTab();
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("------------");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setBold(true);
            run.setText(" PIHAK PERTAMA / PEMBERI FIDUSIA ");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.addTab();
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("b. Menurut keterangannya dalam hal ini bertindak ");
            run.addTab();
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("untuk dan atas nama direksi serta mewakili Perseroan Terbatas ");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setBold(true);
            run.setText("PT. BANK PEREKONOMIAN RAKYAT BANTORU PERINTIS");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(", berkedudukan di Kota Depok, yang anggaran dasarnya dimuat dalam Akta Pendirian Nomor 12, tertanggal 07-10-1991 tujuh Oktober seribu sembilan ratus sembilan puluh satu), yang dibuat dihadapan ");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setBold(true);
            run.setText("MOHAMAD ALI, Sarjana Hukum");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(", Notaris di Jakarta, dan telah mendapat pengesahan dari Menteri Kehakiman Republik Indonesia Nomor C2-7479 HT.01.01 TH.95, tertanggal 21-10-1991 (dua puluh satu Oktober seribu sembilan ratus sembilan puluh satu).");
            run.addTab();
            run.addBreak();
            run.setText("-Anggaran Dasar mana telah mengalami beberapa kali perubahan, terakhir dengan Akta Pernyataan Keputusan Rapat Umum Perseroan Terbatas ");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setBold(true);
            run.setText("PT. BANK PEREKONOMIAN RAKYAT BANTORU PERINTIS");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(", Nomor : 55, tanggal 13-11-2024 (tiga belas November dua ribu dua puluh empat), yang dibuat dihadapan ");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setBold(true);
            run.setText("LINDA LAMOUR TAMPUBOLON, Sarjana Hukum, Magister Kenotariatan");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(", Notaris di Kabupaten Purwakarta, dan telah mendapat pengesahan dari Menteri Hukum dan Hak Asasi Manusia Republik Indonesia, Nomor : AHU-0073715.AH.01.02. TAHUN 2024 tanggal 14-11-2024 (empat belas November dua ribu dua puluh empat).");
            run.addTab();
            run.addBreak();
            run.setText("-Selanjutnya akan disebut juga :");
            run.addTab();
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("------------");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setBold(true);
            run.setText(" PIHAK KEDUA / PENERIMA FIDUSIA ");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.addTab();
        }
    }

    public void PemberiFidusia(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String bank, String cabang, String[] pemberi) {
        String fpemberiktgr = pemberi[1];
        String fpemberinik = pemberi[2];
        String fpemberipanggil = pemberi[4];
        String fpemberinama = pemberi[5];
        String fpemberilahirtempat = pemberi[6];
        String fpemberilahirtgl = pemberi[7];
        String fpemberikerja = pemberi[9];
        String fpemberialamat = pemberi[10];
        String fpemberikel = pemberi[11].replace("_", " ");
        String fpemberikec = pemberi[12].replace("_", " ");
        String fpemberikota = pemberi[13].replace("_", " ");
        String fpemberiprop = pemberi[14].replace("_", " ");
        String fpemberirt = pemberi[15];
        String fpemberirw = pemberi[16];
        String fpemberiwn = pemberi[19];
        String fpemberisetuju = pemberi[20];
        String fsetujunik = pemberi[21];
        String fsetujupanggil = pemberi[22];
        String fsetujunama = pemberi[23];
        String fsetujulahirtempat = pemberi[24];
        String fsetujulahirtgl = pemberi[25];
        String fsetujukerja = pemberi[26];
        String fsetujualamat = pemberi[27];
        String fsetujukel = pemberi[28];
        String fsetujukec = pemberi[29];
        String fsetujukota = pemberi[30];
        String fsetujuprop = pemberi[31];
        String fsetujurt = pemberi[32];
        String fsetujurw = pemberi[33];
        String fsetujuwn = pemberi[34];
        String fpemberibadannama = pemberi[40];
        String fpemberibadankab = pemberi[44].replace("_", " ");
        String fpemberibadanket = pemberi[50];
        this.PemberiFidusia1(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, fpemberipanggil, fpemberinama, fpemberilahirtempat, fpemberilahirtgl, fpemberikerja, fpemberialamat, fpemberikel, fpemberikec, fpemberikota, fpemberiprop, fpemberirt, fpemberirw, fpemberiwn, fpemberinik);
        if (fpemberiktgr.equals("Perseorangan")) {
            this.PemberiFidusia2(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, fpemberipanggil, fpemberisetuju, fsetujupanggil, fsetujunama, fsetujulahirtempat, fsetujulahirtgl, fsetujukerja, fsetujualamat, fsetujukel, fsetujukec, fsetujukota, fsetujuprop, fsetujurt, fsetujurw, fsetujuwn, fsetujunik);
        } else {
            this.PemberiFidusia3(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, fpemberibadannama, fpemberibadankab, fpemberibadanket);
            XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 260, ktgr, rgb);
            XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("Untuk selanjutnya disebut dengan Perseroan.");
            run.addTab();
        }
    }

    public void PemberiFidusia1(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String fpemberipanggil, String fpemberinama, String fpemberilahirtempat, String fpemberilahirtgl, String fpemberikerja, String fpemberialamat, String fpemberikel, String fpemberikec, String fpemberikota, String fpemberiprop, String fpemberirt, String fpemberirw, String fpemberiwn, String fpemberinik) {
        String[] pemberitg = this.xhelp.ConvertYMDtoDMY(fpemberilahirtgl, "-");
        String fkerja = "";
        fkerja = fpemberikerja.equals("-") ? "" : String.valueOf(fpemberikerja) + ", ";
        XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText(String.valueOf(fpemberipanggil) + " ");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText(fpemberinama);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText(", lahir di " + fpemberilahirtempat + ", pada tanggal ");
        run.setText(String.valueOf(pemberitg[0]) + "-" + pemberitg[1] + "-" + pemberitg[2] + " (" + this.xhelp.terbilangTgl(pemberitg[0], pemberitg[1], pemberitg[2]) + "), ");
        run.setText("Warga Negara " + fpemberiwn + ", " + fkerja + "bertempat tinggal di " + fpemberialamat + ", Rukun Tetangga " + fpemberirt + ", Rukun Warga " + fpemberirw + ", Kelurahan/Desa " + this.xhelp.capitalize(fpemberikel.toLowerCase()).trim() + ", Kecamatan " + this.xhelp.capitalize(fpemberikec.toLowerCase()).trim() + ", " + this.xhelp.capitalize(fpemberikota.toLowerCase()).trim() + ", Provinsi " + this.xhelp.capitalize(fpemberiprop.toLowerCase()).trim() + ", ");
        if (fpemberiwn.equals("Indonesia")) {
            run.setText("pemegang Kartu Tanda Penduduk dengan Nomor : " + fpemberinik + ", ");
        } else {
            run.setText("pemegang Paspor " + fpemberiwn + " Nomor : " + fpemberinik + ", ");
        }
        run.addTab();
    }

    public void PemberiFidusia2(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String fpemberipanggil, String fpemberisetuju, String fsetujupanggil, String fsetujunama, String fsetujulahirtempat, String fsetujulahirtgl, String fsetujukerja, String fsetujualamat, String fsetujukel, String fsetujukec, String fsetujukota, String fsetujuprop, String fsetujurt, String fsetujurw, String fsetujuwn, String fsetujunik) {
        String fsetuju = "";
        String fsetuju1 = "";
        String fsetuju2 = "";
        String[] setujutg = this.xhelp.ConvertYMDtoDMY(fsetujulahirtgl, "-");
        if (fpemberisetuju.equals("suamiistri")) {
            String fpemberipanggilcek = fpemberipanggil.toLowerCase();
            if (fpemberipanggilcek.equals("tuan")) {
                fsetuju2 = "pasangan";
                fsetuju = "pasangan";
            } else {
                fsetuju2 = "pasangan";
                fsetuju = "pasangan";
            }
        } else if (fpemberisetuju.equals("anak")) {
            fsetuju = "orang tua";
            fsetuju2 = "anak";
        } else if (fpemberisetuju.equals("orangtua")) {
            fsetuju = "anak";
            fsetuju2 = "orang tua";
        }
        if (fsetujualamat != null && !fsetujualamat.equals("")) {
            fsetuju1 = !fsetujualamat.equals("-") ? "di " + fsetujualamat + ", Rukun Tetangga " + fsetujurt + ", Rukun Warga " + fsetujurw + ", Kelurahan/Desa " + this.xhelp.capitalize(fsetujukel.toLowerCase()).trim() + ", Kecamatan " + this.xhelp.capitalize(fsetujukec.toLowerCase()).trim() + ", " + this.xhelp.capitalize(fsetujukota.toLowerCase()).trim() + ", Provinsi " + this.xhelp.capitalize(fsetujuprop.toLowerCase()).trim() : "bersama-sama dengan " + fsetuju + "nya tersebut diatas";
        }
        if (fpemberisetuju.equals("suamiistri") || fpemberisetuju.equals("anak") || fpemberisetuju.equals("orangtua")) {
            XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
            XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("- Menurut keterangannya, untuk melakukan tindakan hukum dalam akta ini penghadap telah mendapatkan persetujuan dari " + fsetuju2 + "nya yaitu : ");
            run.addTab();
            run.addBreak();
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("- " + fsetujupanggil + " ");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setBold(true);
            run.setText(fsetujunama);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(", lahir di " + fsetujulahirtempat + ", pada tanggal ");
            run.setText(String.valueOf(setujutg[0]) + "-" + setujutg[1] + "-" + setujutg[2] + " (" + this.xhelp.terbilangTgl(setujutg[0], setujutg[1], setujutg[2]) + "), ");
            run.setText("Warga Negara " + fsetujuwn + ", " + fsetujukerja + ", bertempat tinggal " + fsetuju1 + ", ");
            if (fsetujuwn.equals("Indonesia")) {
                run.setText("pemegang Kartu Tanda Penduduk dengan Nomor : " + fsetujunik + "; ");
            } else {
                run.setText("pemegang Paspor Nomor : " + fsetujunik + "; ");
            }
            run.addTab();
        }
    }

    public void PemberiFidusia3(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String fpemberibadannama, String fpemberibadankab, String fpemberibadanket) {
        XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("- yang dalam melakukan tindakan hukum sebagaimana ternyata dalam surat kuasa tersebut diatas, mewakili Perseroan dalam jabatannya selaku Direktur dari Perseroan yang akan disebutkan di bawah ini dan oleh karena itu untuk dan atas nama : ");
        run.addTab();
        run.addBreak();
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("-");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText(fpemberibadannama);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText(", yang berkedudukan di " + this.xhelp.capitalize(fpemberibadankab.toLowerCase()).trim() + ", ");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText(fpemberibadanket);
        run.addTab();
    }

    public void Debitur(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String bank, String cabang, String[] debitur) {
        XWPFRun run;
        XWPFParagraph paragraph;
        String nik = debitur[1];
        String panggil = debitur[2];
        String nama = debitur[3];
        String lahirtempat = debitur[4];
        String lahirtgl = debitur[5];
        String[] tg = this.xhelp.ConvertYMDtoDMY(lahirtgl, "-");
        String kerja = debitur[6];
        String alamat = debitur[7];
        String kel = debitur[8];
        String kec = debitur[9];
        String kab = debitur[10];
        String prop = debitur[11];
        String rt = debitur[12];
        String rw = debitur[13];
        String wn = debitur[14];
        String setuju = debitur[15];
        String setujunik = debitur[16];
        String setujupanggil = debitur[17];
        String setujunama = debitur[18];
        String setujulahirtempat = debitur[19];
        String setujulahirtgl = debitur[20];
        String setujukerja = debitur[21];
        String setujualamat = debitur[22];
        String setujukel = debitur[23];
        String setujukec = debitur[24];
        String setujukab = debitur[25];
        String setujuprop = debitur[26];
        String setujurt = debitur[27];
        String setujurw = debitur[28];
        String setujuwn = debitur[29];
        String badannama = debitur[30];
        String badankab = debitur[31];
        String badanket = debitur[32];
        String awal = "A. Bahwa diantara " + panggil + " " + nama + ", lahir di " + lahirtempat + ", pada tanggal";
        if (awal.length() <= 69) {
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(awal);
            run.addTab();
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 260, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
        } else {
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(awal.substring(0, awal.indexOf(" ", 69) + 1));
            run.addTab();
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 260, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(String.valueOf(awal.substring(awal.indexOf(" ", 69) + 1, awal.length())) + " ");
        }
        run.setText(String.valueOf(this.xhelp.terbilangTgl(tg[0], tg[1], tg[2])) + " (" + tg[0] + "-" + tg[1] + "-" + tg[2] + "), ");
        run.setText("Warga Negara " + wn + ", " + kerja + ", " + "bertempat tinggal di " + alamat + ", Rukun Tetangga " + rt + ", Rukun Warga " + rw + ", Kelurahan/Desa " + this.xhelp.capitalize(kel.toLowerCase()).trim() + ", Kecamatan " + this.xhelp.capitalize(kec.toLowerCase()).trim() + ", " + this.xhelp.capitalize(kab.toLowerCase()).trim() + ", Provinsi " + this.xhelp.capitalize(prop.toLowerCase()).trim() + ", ");
        if (wn.equals("Indonesia")) {
            run.setText("pemegang Kartu Tanda Penduduk dengan Nomor Induk Kependudukan : " + nik + ", ");
        } else {
            run.setText("pemegang Paspor Nomor : " + nik + ", ");
        }
        run.addTab();
        this.PemberiFidusia2(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, panggil, setuju, setujupanggil, setujunama, setujulahirtempat, setujulahirtgl, setujukerja, setujualamat, setujukel, setujukec, setujukab, setujuprop, setujurt, setujurw, setujuwn, setujunik);
        if (badannama != null && !badannama.equals("")) {
            this.PemberiFidusia3(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, badannama, badankab, badanket);
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 260, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("satu dan lain sebagaimana ternyata dari Surat Perjanjian Pembiayaan Konsumen yang akan disebut dibawah ini.");
            run.addTab();
        }
    }

    public void PenerimaFidusia(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String bank, String cabang) {
        XWPFRun run;
        XWPFParagraph paragraph;
        if (bank.equals("PT. SGMW MULTIFINANCE INDONESIA")) {
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("II. Tuan ");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setBold(true);
            run.setText("I WAYAN SUHERMAN YASA");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(", lahir di Tabanan,");
            run.addTab();
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 580, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("pada tanggal 30-05-1969 (tiga puluh Mei seribu sembilan ratus enam puluh sembilan), Warga Negara Indonesia, Karyawan Swasta, bertempat tinggal di Banjar Dinas Piling Kawan, Kelurahan/Desa Mengesta, Kecamatan Penebel, Kabupaten Tabanan, Provinsi Bali, pemegang Kartu Tanda Penduduk Nomor Induk Kependudukan : 5271063005690002, yang berlaku seumur hidup;");
            run.addTab();
            run.addBreak();
            run.setText("-Menurut keterangannya dalam hal ini bertindak dalam kedudukannya selaku Direktur Utama dari karenanya untuk dan atas nama Perseroan Terbatas PT. BANK PERKREDITAN RAKYAT MAYUN UTAMA PERDANA, berkedudukan di Kelurahan Abianbase, Kecamatan Mengwi, Kabupaten Badung, Provinsi Bali, yang didirikan dengan akta Nomor 9, tertanggal 05-06-1991 (lima Juni seribu sembilan ratus sembilan puluh satu) yang dibuat dihadapan I MADE PURYATMA, Sarjana Hukum, Notaris di Denpasar, akta mana telah mendapat pengesahan dari Menteri Kehakiman Republik Indonesia dengan Surat Keputusannya Nomor : C2-3458.HT.01.01.Th.91, tertanggal 30-07-1991 (tiga puluh Juli seribu sembilan ratus sembilan puluh satu), yang akta mana telah mengalami beberapa kali perubahan dan perubahan terakhir dengan akta Nomor 01, tertanggal 05-03-2021 (lima Maret dua ribu dua puluh satu), dibuat di hadapan I KETUT SENJAYA, Sarjana Hukum, Notaris di Denpasar akta mana telah diterima dan dicatat di dalam Sistem Administrasi Badan Hukum Nomor : AHU-AH.01.03-0145156, tertanggal 06-03-2021 (enam Maret dua ribu dua puluh satu) karenanya sah bertindak untuk dan atas nama Perseroan Terbatas PT. BANK PERKREDITAN RAKYAT MAYUN UTAMA PERDANA, yang berkedudukan di Kelurahan Abianbase, Kecamatan Mengwi, Kabupaten Badung, Provinsi Bali.");
            run.addTab();
        } else {
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("II. Tuan ");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setBold(true);
            run.setText("YOHANES PUTU SURYANTHA");
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(", lahir di Badung,");
            run.addTab();
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 580, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("pada tanggal 07-02-1972 (tujuh Pebruari seribu sembilan ratus tujuh puluh dua), Warga Negara Indonesia, Karyawan Swasta, bertempat tinggal di Perumahan Sepa Guntur I/C. 21 Denpasar, Kelurahan/Desa Padangsambian, Kecamatan Denpasar Barat, Kota Denpasar, Provinsi Bali, pemegang Kartu Tanda Penduduk Nomor Induk Kependudukan : 5171010702720002, yang berlaku hingga tanggal 07-02-2017 (tujuh Pebruari dua ribu tujuh belas), berdasarkan Surat Edaran Menteri Dalam Negeri Nomor 470/296/SJ tertanggal 29-01-2016 (dua puluh sembilan Januari dua ribu enam belas) tentang Kartu Tanda Penduduk Elektronik berlaku seumur hidup;");
            run.addTab();
            run.addBreak();
            run.setText("-Menurut keterangannya dalam hal ini bertindak dalam jabatannya selaku General Manajer Koperasi Simpan Pinjam WISUDA GUNA RAHARJA, berdasarkan Surat Keputusan Pengurus Koperasi Simpan Pinjam WISUDA GUNA RAHARJA Nomor : 290B/SK/WGR/X/2016 tertanggal 01-10-2016 (satu Oktober dua ribu enam belas), fotocopy surat mana dilekatkan pada minuta akta ini, Anggaran Dasar telah mendapat pengesahan berdasarkan Surat Keputusan Kantor Wilayah Koperasi Propinsi Bali Nomor : 41/DK-22/D1-XI/1981, dan telah pula mendapat pengesahan dari Departemen Koperasi dan Pembinaan Pengusaha Kecil Propinsi Bali Nomor : 202/BH/PAD/KWK.22/III/1996 tertanggal 26-03-1996 (dua puluh enam Maret seribu sembilan ratus sembilan puluh enam), Anggaran Dasar tersebut dirubah dengan Akta Nomor : 01, tertanggal 17-10-2016 (tujuh belas Oktober dua ribu enam belas) dibuat dihadapan INTI SARIWATI, Sarjana Hukum, Notaris di Denpasar, dari karenanya untuk dan atas nama serta sah mewakili Koperasi Simpan Pinjam WISUDA GUNA RAHARJA berkedudukan di Denpasar.");
            run.addTab();
        }
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("-Selanjutnya dalam akta ini disebut ");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText("PIHAK KEDUA");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText(" atau ");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText("PENERIMA FIDUSIA");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText(".");
        run.addTab();
    }

    public void Obyek(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String bank, String cabang, String bpkbnm, String[][] listObyek) {
        String[][] arr = listObyek;
        XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("(" + arr.length + ") unit kendaraan bermotor roda empat (4) (Mobil), dengan rincian sebagai berikut : ");
        run.addTab();
        int ir = 0;
        while (ir < arr.length) {
            String fobyeknilai3;
            String fobyekktgr = arr[ir][2].replace("_", " ");
            String fobyeknilai = arr[ir][3];
            if (fobyeknilai.contains(".")) {
                int tpon = fobyeknilai.indexOf(".");
                String fobyeknilai1 = fobyeknilai.substring(0, tpon);
                String fobyeknilai2 = fobyeknilai.substring(tpon + 1, fobyeknilai.length());
                fobyeknilai3 = String.valueOf(this.xhelp.terbilang(fobyeknilai1)) + "rupiah koma " + this.xhelp.terbilang(fobyeknilai2) + "sen";
            } else {
                fobyeknilai3 = String.valueOf(this.xhelp.terbilang(fobyeknilai)) + "rupiah";
            }
            String fobyekmerk = arr[ir][4];
            String fobyektype = arr[ir][5];
            String fobyeknoka = arr[ir][6];
            String fobyeknosin = arr[ir][7];
            String fobyekwarna = arr[ir][8];
            String fobyeknopol = arr[ir][9];
            String fobyekjenis = arr[ir][10];
            String fobyekmodel = arr[ir][11];
            String fobyekcc = arr[ir][12];
            String fobyekthn = arr[ir][13];
            String fobyekbukti = arr[ir][14];
            String fobyekkondisi = arr[ir][15];
            String fobyekjuncto = arr[ir][16];
            String fobyekjunctono = arr[ir][17];
            String fobyekjunctonm = arr[ir][18];
            String fobyekjunctotgl = arr[ir][19];
            String fobyekjunctokeluar = arr[ir][20];
            String fobyekjuncto1 = arr[ir][23];
            String fobyekjuncto1tgl = arr[ir][24];
            fobyekkondisi = arr[ir][15];
            String fobyekdealer = arr[ir][25];
            String fjuncto2 = "";
            String fjuncto2tgl = "";
            String fjuncto2no = "";
            String fkoma = "";
            String fter = "";
            if (!fobyekjunctono.equals("") && !fobyekjunctono.equals("-")) {
                fjuncto2no = "nomor " + fobyekjunctono + ",";
                fkoma = " ";
            } else {
                fjuncto2no = "";
                fkoma = ",";
            }
            if (!fobyekjunctotgl.equals("") && fobyekjunctotgl.contains("-")) {
                String[] fjunctotg = this.xhelp.ConvertYMDtoDMY(fobyekjunctotgl, "-");
                fter = fobyekkondisi.equals("bekas") ? "ter" : "";
                fjuncto2tgl = String.valueOf(fter) + "tanggal " + this.xhelp.terbilangTgl(fjunctotg[0], fjunctotg[1], fjunctotg[2]) + " (" + fjunctotg[0] + "-" + fjunctotg[1] + "-" + fjunctotg[2] + ")" + fkoma;
            } else {
                fjuncto2tgl = "";
            }
            fjuncto2 = String.valueOf(fjuncto2tgl) + fjuncto2no;
            String fjuncto12 = "";
            if (!fobyekjuncto1tgl.equals("") && fobyekjuncto1tgl.contains("-")) {
                String[] fjuncto1tg = this.xhelp.ConvertYMDtoDMY(fobyekjuncto1tgl, "-");
                fjuncto12 = "tanggal " + this.xhelp.terbilangTgl(fjuncto1tg[0], fjuncto1tg[1], fjuncto1tg[2]) + " (" + fjuncto1tg[0] + "-" + fjuncto1tg[1] + "-" + fjuncto1tg[2] + ")";
            }
            int max = 26;
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Merk                :", false, fobyekmerk, false);
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Type               :", false, fobyektype, false);
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Jenis               :", false, fobyekjenis, false);
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Model               :", false, fobyekmodel, false);
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Tahun Pembuatan     :", false, fobyekthn, false);
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Tahun Perakitan     :", false, fobyekthn, false);
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Warna               :", false, fobyekwarna, false);
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Bahan Bakar         :", false, fobyekmerk, false);
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Nomor Rangka        :", false, fobyeknoka, false);
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Nomor Mesin         :", false, fobyeknosin, false);
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Nomor BPKB          :", false, fobyekjunctono, false);
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Nomor Polisi        :", false, fobyeknopol, false);
            this.help.TabelFormat(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, 420, 3160, "- Terdaftar atas nama :", false, bpkbnm, true);
            if (arr.length == 1) {
                paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 260, ktgr, rgb);
                run = this.docx.huruf(paragraph, font_name, font_size);
                run.setText("- Jenis Kendaraan           : " + fobyekktgr + ";");
                run.addTab();
            } else {
                paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
                run = this.docx.huruf(paragraph, font_name, font_size);
                run.setText(String.valueOf(ir + 1) + ". - Jenis Kendaraan           : " + fobyekktgr + ";");
                run.addTab();
            }
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 260, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("- Merk Kendaraan            : " + fobyekmerk + ";");
            run.addTab();
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 260, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            if (fobyektype.length() <= 38) {
                run.setText("- Type Kendaraan            : " + fobyektype + ". ");
                run.addTab();
            } else {
                run.setText("- Type Kendaraan            : " + fobyektype.substring(0, fobyektype.indexOf(" ", 39) + 1));
                run.addTab();
                paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 2860, ktgr, rgb);
                run = this.docx.huruf(paragraph, font_name, font_size);
                run.setText(String.valueOf(fobyektype.substring(fobyektype.indexOf(" ", 39) + 1, fobyektype.length())) + ";");
                run.addTab();
            }
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 260, ktgr, rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("- Nomor Rangka              : " + fobyeknoka + ";");
            run.addTab();
            run.addBreak();
            run.setText("- Nomor Mesin                 : " + fobyeknosin + ";");
            run.addTab();
            run.addBreak();
            run.setText("- Tahun Kendaraan          : " + fobyekthn + ";");
            run.addTab();
            run.addBreak();
            if (bank.equals("PT. SGMW MULTIFINANCE INDONESIA") || bank.equals("PT. SGMW MULTIFINANCE INDONESIA DAN PT. BANK SINARMAS TBK")) {
                run.setText("- Warna Kendaraan          : " + fobyekwarna + ";");
                run.addTab();
                run.addBreak();
                run.setText("- Atas Nama                     : " + fobyekjunctonm + ";");
                run.addTab();
                run.addBreak();
            }
            if (bank.equals("PT. SGMW MULTIFINANCE INDONESIA") || bank.equals("PT. SGMW MULTIFINANCE INDONESIA DAN PT. BANK SINARMAS TBK")) {
                if (fobyekkondisi.equals("bekas")) {
                    run.setText("Sedangkan BPKB sedang dalam proses balik nama keatas nama ");
                    run.setText(bpkbnm);
                    run.setText(" sebagaimana diuraikan dalam ");
                    run.setText(fobyekjuncto);
                    run.setText(" bermaterai cukup " + fjuncto2 + " surat mana yang diperlihatkan kepada saya, Notaris");
                    run.addTab();
                    run.addBreak();
                } else {
                    run.setText("Sedangkan BPKB sedang dalam pengurusan pada instansi terkait sebagaimana ");
                    run.setText(fobyekjuncto);
                    run.setText(" yang dikeluarkan " + fjuncto2 + " oleh " + fobyekdealer + " yang diperlihatkan kepada saya, Notaris");
                    run.addTab();
                    run.addBreak();
                }
                run.setText("dengan nilai objek Jaminan fidusia sebesar ");
            } else {
                run.setText("-Sebagaimana ternyata dari kendaraan bermotor dengan nilai objek sebesar ");
            }
            run.setText(String.valueOf(this.xhelp.formatRp(Double.parseDouble(fobyeknilai))) + " (" + fobyeknilai3 + ").");
            run.addTab();
            ++ir;
        }
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("-Untuk selanjutnya dalam akta ini cukup disebut dengan ");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText("Objek Jaminan Fidusia");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText(".");
        run.addTab();
    }

    public void PasalJudul(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String pasal) {
        String minleft = "----------------------";
        XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText(minleft);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText(" " + pasal + " ");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.addTab();
    }

    public void PasalBPRBP(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String bank, String bankcabang, String bpkbnm, String[] pemberi, String[][] listObyek) {
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 1");
        XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Untuk menjamin terbayarnya dengan baik segala sesuatu yang terhutang dan harus dibayar oleh Pemberi Fidusia kepada Penerima Fidusia, baik berupa hutang pokok, bunga dan biaya-biaya lainnya yang timbul berdasarkan Perjanjian Kredit (\u201c");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText("Hutang");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("\u201d), maka Pemberi Fidusia dengan ini mengalihkan secara fidusia kepada Penerima Fidusia jaminan fidusia sebagai berikut :");
        run.addTab();
        this.Obyek(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, bank, bankcabang, bpkbnm, listObyek);
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 2");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("1. Pembebanan jaminan fidusia atas Obyek Jaminan ");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Fidusia telah dilakukan di tempat dimana Obyek Jaminan Fidusia berada dan telah menjadi miliknya Penerima Fidusia, sedang Obyek Jaminan Fidusia Tersebut tetap berada pada dan dalam kekuasaan Pemberi Fidusia selaku peminjam pakai.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("2. Apabila untuk penguasaan Obyek Jaminan Fidusia ");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("oleh Pemberi Fidusia diperlukan suatu kuasa khusus, maka Penerima Fidusia, dengan ini memberi kuasa kepada Pemberi Fidusia untuk melakukan tindakan yang diperlukan tersebut.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 3");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Obyek Jaminan Fidusia hanya dapat dipergunakan oleh Pemberi Fidusia menurut sifat dan peruntukannya, dengan tidak ada kewajiban bagi Pemberi Fidusia untuk membayar biaya /ganti rugi berupa apapun untuk pinjam pakai tersebut kepada Penerima Fidusia. ");
        run.addTab();
        run.addBreak();
        run.setText("Namun Pemberi Fidusia berkewajiban untuk memelihara Obyek Jaminan Fidusia tersebut dengan sebaik baiknya dan melakukan semua tindakan yang diperlukan untuk pemeliharaan dan perbaikan atas Obyek Jaminan Fidusia atas biaya dan tanggungan Pemberi Fidusia sendiri, serta membayar pajak dan beban lainnya atas Obyek Jaminan Fidusia (bilamanaada).");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 4");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("1. Penerima Fidusia atau wakilnya yang sah setiap ");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("waktu berhak namun tidak diwajibkan dan dengan ini telah diberi kuasa dengan hak substitusi oleh Pemberi Fidusia untuk memeriksa keadaan dan keberadaan Obyek Jaminan Fidusia.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("2. Penerima Fidusia atau wakilnya yang sah atas biaya ");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Pemberi Fidusia berhak namun tidak diwajibkan, untuk melakukan atau menyuruh melakukan segala sesuatu yang seharusnya dilakukan oleh Pemberi Fidusia atas Obyek Jaminan Fidusia dalam hal Pemberi Fidusia melalaikan kewajibannya untuk memelihara Obyek Jaminan Fidusia dalam keadaan terpelihara baik, Obyek Jaminan Fidusia disimpan atau berada. Para Pihak menyatakan bahwa tindakan tersebut tidak merupakan tindakan memasuki tempat dan/atau bangunan tanpa izin.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 5");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("1. Dalam hal Pemberi Fidusia tidak menjalankan atau ");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("memenuhi salah satu ketentuan dalam akta ini dan/atau salah satu ketentuan dalam Perjanjian Kredit, terutama dalam hal Pemberi Fidusia lalai melakukan pembayaran kembali Hutang, sedangkan kelalaian tersebut semata-mata terbukti dengan lewatnya waktu yang ditentukan, tanpa untuk itu diperlukan lagi sesuatu surat teguran juru sita atau surat lain yang serupa dengan itu, maka : ");
        run.addTab();
        run.addBreak();
        run.setText("i.\tSetelah pemberian waktu selama 15 (lima belas)");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 840, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Hari dari tanggal atas kelalaian atau wanprestasi yang dilakukan oleh Pemberi Fidusia, maka Penerima Fidusia berhak untuk menjual Obyek Jaminan Fidusia atas dasar title eksekut orial, atau melalui pelelangan dimuka umum, atau melalui penjualan dibawah tangan yang dilakukan berdasarkan kesepakatan Pemberi Fidusia dan Penerima Fidusia jika dengan cara demikian diperoleh harga tertinggi yang menguntungkan para pihak. Untuk keperluan penjualan tersebut, Penerima Fidusia berhak menghadap pejabat atau instansi yang berwenang, dimana perlu membuat atau menyuruh membuat serta menandatangani semua surat, akta serta dokumen lain yang diperlukan, menerima uang harga penjualan dan memberikan tanda penerimaan untuk itu, menyerah kanapa yang dijual itu kepada pembelinya, memperhitungkan atau mengkompensir uang harga penjualan yang diterimanya itu dengan semua apa yang wajib dibayar oleh Pemberi Fidusia kepada Penerima Fidusia, dan untuk menyerahkan sisa uang penjualannya jika masih ada kepada Pemberi Fidusia, dengan tidak ada kewajiban bagi Penerima Fidusia untuk membayar bunga atau ganti kerugian berupa apapun juga kepada Pemberi Fidusia (jika masihada) mengenai sisa uang harga penjualan itu, selanjutnya Penerima Fidusia juga berhak untuk melakukan segala sesuatu yang dipandang perlu dan berguna dalam rangka penjualan Obyek Jaminan Fidusia dengan tidak satupun yang dikecualikan.");
        run.addTab();
        run.addBreak();
        run.setText("Pemberi Fidusia membebaskan Penerima Fidusia dari segala tuntutan atau klaim dari pihak ketiga yang membeli Obyek Jaminan Fidusia melalui proses eksekusi Obyek Jaminan Fidusia.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("2. Apabila uang yang diterima dari penjualan Obyek");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Jaminan Fidusia tidak mencukupi untuk melunasi semua apa yang wajib dibayar oleh Pemberi Fidusia kepada Penerima Fidusia berdasarkan Perjanjian Kredit, maka Pemberi Fidusia tetap terikat membayar lunas sisa uang yang masih harus dibayar oleh Pemberi Fidusia kepada Penerima Fidusia.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 6");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Penerima Fidusia atau kuasanya berwenang untuk melaksanakan Pendaftaran Jaminan Fidusia berdasarkan perjanjian ini pada Kantor Pendaftaran Jaminan Fidusia Kementerian Hukum dan Hak Asasi Manusia Republik Indonesia, Kantor wilayah Tangerang. Untuk keperluan tersebut, Penerima Fidusia atau kuasanya\u2014berwenang menghadap dihadapan pejabat atau instansi yang berwenang, memberikan keterangan, menandatangani surat/formulir, mendaftarkan Jaminan Fidusia atas Obyek Jaminan Fidusia dengan melampirkan Pernyataan Pendaftaran Jaminan Fidusia, dan mengajukan permohonan perubahan dalam hal terjadi perubahan atas data yang tercantum dalam Sertifikat Jaminan Fidusia, selanjutnya menerima Sertifikat Jaminan Fidusia dan/ atau Pernyataan Perubahan serta dokumen-dokumen lain yang berhubungan dengan hal tersebut. Untuk keperluan itu, Penerima Fidusia atau kuasanya berwenang membayar semua biaya dan menerima kwitansi segala uang pembayaran serta selanjutnya melakukan segala tindakan yang perlu dan berguna untuk melaksanakan ketentuan dari akta ini.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 7");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("1.\tPemberi Fidusia dilarang untuk melakukan fidusia");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("ulang atas Obyek Jaminan Fidusia.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("2.\tPemberi Fidusia juga tidak diperkenankan untuk");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Membebankan atau menggadaikan dengan cara apapun kepada pihak lain, kecuali dengan persetujuan tertulis terlebih dahulu dari Penerima Fidusia.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 8");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("1.\tPemberi Fidusia dengan ini memberikan kuasa kepada");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Penerima Fidusia dengan hak memindahkan/ mensubstitusikan kuasa ini kepada orang atau pihak lain, pada setiap waktu yang dipandang baik oleh Penerima Fidusia untuk melakukan tindakan apapun yang diwajibkan atau dipandang perlu guna memberitahukan dengan resmi kepada atau memperoleh pengakuan dari pihak ketiga mengenai penyerahan Obyek Jaminan Fidusia berdasarkan perjanjian ini, semuanya atas biaya Pemberi Fidusia.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("2. Akta ini merupakan bagian yang tidak dapat");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Dipisahkan dari Perjanjian Kredit, demikian pula kuasa yang diberikan dalam akta ini merupakan bagian yang tidak terpisahkan dari akta ini, tanpa adanya kuasa tersebut, Perjanjian Kredit demikian pula akta ini tidak akan diterima dan dilangsungkan diantara para pihak yang bersangkutan, oleh karenanya kuasa tersebut tidak dapat ditarik kembali atau dibatalkan atau berakhir karena sebab yang dapat mengakhiri pemberian sesuatu kuasa, termasuk sebab yang disebutkan dalam Pasal 1813, 1814 dan 1816 Kitab Undang-Undang Hukum Perdata Indonesia.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 9");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("1.\tPemberi Fidusia menjamin dan menyatakan kepada");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Penerima Fidusia bahwa : ");
        run.addTab();
        run.addBreak();
        run.setText("(i)   Obyek Jaminan Fidusia adala milik/hak");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 1290, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Pemberi Fidusia sendiri dan tidak ada orang/pihak lain yang turut memiliki atau mempunyai hak apapun atas obyek Jaminan Fidusia.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("(ii)  Obyek Jaminan Fidusia sebelumnya belum");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 1290, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Pernah dijual/dialihkan kepemilikannya, atau dioperkan dengan cara bagaimanapun dan kepada siapapun.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("(iii) Obyek Jaminan Fidusia tidak tersangkut");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 1290, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("perkara/sengketa dan tidak dalam sitaan.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("(iv)  Obyek Jaminan Fidusia tidak dan tidak akan");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 1290, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Pernah dijaminkan atau diagunkan dengan cara bagaimanapun dan kepada orang/pihak manapun, kecuali kepada Penerima Fidusia.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("(v)   Penyerahan Obyek Jaminan Fidusia");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 1290, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("berdasarkan perjanjian ini tidak dilakukan dengan memalsukan, mengubah, menghilangkan atau dengan cara apapun memberikan keterangan secara menyesatkan, yang jika hal tersebut diketahui oleh Penerima Fidusia, perjanjian ini tidak akan dibuat.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("2. Pemberi Fidusia dengan ini pula membebaskan dan");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("melepaskan Penerima Fidusia atau kuasanya dari semua tuntutan/gugatan yang diajukan oleh orang/pihak siapapun juga mengenai atau berhubungan dengan hal-hal yang dijamin oleh Pemberi Fidusia sebagai mana diuraikan diatas, dan atas permintaan pertama dari Penerima Fidusia atau kuasanya, Pemberi Fidusia wajib mengurus, menyelesaikan dan membayar tuntutan, gugatan, atau tagihan tersebut atas biaya dan tanggung jawab Pemberi Fidusia sendiri, kecuali yang disebabkan karena kelalaian atau kesengajaan dari Penerima Fidusia.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 10");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Pengalihan secara fidusia atas Obyek Jaminan Fidusia berdasarkan perjanjian ini dilakukan dengan tujuan untuk memberikan jaminan bagi terbayarnya dengan baik segala sesuatu yang terhutang dan harus dibayar oleh Pemberi Fidusia kepada Penerima Fidusia berdasarkan Perjanjian Kredit, dan dengan demikian tidak membatasi atau menghalangi Penerima Fidusia untuk memperoleh segala pelunasan dan pelaksanaan kewajiban-kewajiban dari Pemberi Fidusia berdasarkan Perjanjian Kredit. ");
        run.addTab();
        run.addBreak();
        run.setText("Demikian juga, pembebanan Jaminan Fidusia berdasarkan perjanjian ini bukan merupakan pembayaran atas segala sesuatu yang terhutang dan harus dibayar oleh Pemberi Fidusia kepada Penerima Fidusia, kecuali hingga Penerima Fidusia menerima dan menggunakan Obyek Jaminan Fidusia guna pelunasan kewajiban-kewajiban Pemberi Fidusia berdasarkan Perjanjian Kredit.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 11");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("1.\tJaminan yang diberikan berdasarkan dengan akta ini");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("adalah jaminan yang berkelanjutan dan merupakan jaminan yang terpisah dari jaminan-jaminan lain yang dari waktu ke waktu dipegang oleh Penerima Fidusia untuk seluruh Hutang Pemberi Fidusia berdasarkan Perjanjian Kredit.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("2. Penerima Fidusia berhak untuk meminta jaminan ");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("tambahan dari Pemberi Fidusia atau dari pihak ketiga manapun dan/ atau untuk melepaskan jaminan tersebut dengan persetujuan dari atau pemberitahuan terlebih dahulu kepada Pemberi Fidusia dan/ atau untuk menyetujui setiap perubahan terhadap Perjanjian Kredit, tanpa mempengaruhi kewajiban Pemberi Fidusia berdasarkan akta ini.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("3.\tKegagalan atau keterlambatan Penerima Fidusia,");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("dalam melaksanakan suatu hak, kuasa atau hak istimewa oleh yang diberikan berdasarkan akta ini, tidak dapat dianggap sebagai suatu pelepasan atau sesuatu hak, kuasa atau hak istimewa tersbut dan pelaksanaan dari setiap atau sebagian hak, kuasa atau hak istimewa tersebut tidak dapat menghalangi pelaksanaan lebih lanjut dari setiap hak, kuasa atau hak istimewa tersebut atau pelaksanaan hak, kuasa atau hak istimewa lainnya.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 12");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("- Penerima Fidusia berdasarkan Perjanjian Kredit dan");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("perjanjian dalam akta ini berhak untuk mengalihkan baik keseluruhan ataupun sebagian hak-hak yang timbul dari perjanjian dalam akta ini kepada pihak lain.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("- Dalam hal terjadi pengalihan jaminan fidusia kepada");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("pihak lain, maka Pemberi Fidusia dengan ini setuju bahwa setiap pihak penerima pengalihan berhak atau manfaat dan hak-hak dari pemberian jaminan yang diberikan oleh Pemberi Fidusia berdasarkan akta ini dan oleh karena itu memberikan kuasa dengan hak substitusi kepada penerima fidusia yang baru untuk melakukan perubahan terhadap ketentuan-ketentuan dalam akta ini serta untuk memperbaharui akta ini guna mengakomodasikan kepentingan pihak penerima fidusia yang baru, sebagaimana yang dianggap layak oleh Penerima Fidusia.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 13");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Pengalihan secara fidusia berdasarkan Perjanjian ini akan berakhir dengan sendirinya pada saat Pemberi Fidusia dengan sendirinya pada saat Pemberi Fidusia telah memenuhi/ membayar lunas semua kewajibannya kepada Penerima Fidusia sebagaimana dinyatakan dalam Perjanjian Kredit sesuai dengan ketentuan hukum yang berlaku, dan dalam hal demikian, maka Obyek Jaminan Fidusia berikut dokumen-dokumen yang telah diterima oleh Penerima Fidusia, beralih dengan sendirinya menurut hukum kepada Pemberi Fidusia.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 14");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("1.\tSeluruh surat menyurat atau pemberitahuan");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Pemberitahuan dalam Perjanjian ini harus dilakukan secara tertulis dan dapat disampaika nmelalui surat, email, atau faksimili.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("2. Setiap surat menyurat atau pemberitahuan ");
        run.addTab();
        String pemberinama = pemberi[5];
        String pemberialamat = pemberi[10];
        String pemberikel = pemberi[11].replace("_", " ");
        String pemberikec = pemberi[12].replace("_", " ");
        String pemberikota = pemberi[13].replace("_", " ");
        String pemberiprop = pemberi[14].replace("_", " ");
        String pemberirt = pemberi[15];
        String pemberirw = pemberi[16];
        String pemberitelp = pemberi[18];
        String pemberialmt = "bertempat tinggal di Provinsi " + pemberiprop + ", " + pemberialamat + ", Rukun Tetangga " + pemberirt + ", Rukun Warga " + pemberirw + ", Kelurahan/Desa " + pemberikel + ", Kecamatan " + pemberikec + ", " + pemberikota;
        String penerimanama = "PT. BANK PEREKONOMIAN RAKYAT BANTORU";
        String penerimaalamat = "Jalan Proklamasi Blok B Nomor 7-8, Mekarjaya, Sukmajaya, Kota Depok";
        String penerimatelp = "(021) 7701256";
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("dialamatkan kepada alamat-alamat sebagai berikut :");
        run.addTab();
        run.addBreak();
        run.setText("Pemberi Fidusia  :");
        run.addTab();
        int max = 28;
        this.TabelFormatText(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, "Nama             :", pemberinama);
        this.TabelFormatText(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, "Alamat           :", pemberialmt);
        this.TabelFormatText(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, "Untuk perhatian  :", "");
        this.TabelFormatText(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, "Nomor telepon    :", pemberitelp);
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Penerima Fidusia :");
        run.addTab();
        this.TabelFormatText(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, "Nama             :", penerimanama);
        this.TabelFormatText(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, "Alamat           :", penerimaalamat);
        this.TabelFormatText(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, max, "Nomor telepon    :", penerimatelp);
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("3. Pemberitahuan yang diserahkan secara langsung");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("dianggap telahditerima pada hari penyerahan dengan bukti tanda tangan penerimaan pada buku tanda terima pengirim, sedangkan pengiriman melalui email atau faksimili dianggap telah diterima pada saat telah diterima kode jawaban (answerback) pada konfirmasi pengiriman faksimili.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 15");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Dalam hal satu persyaratan atau ketentuan dalam akta ini dinyatakan batal berdasarkan suatu peraturan perundang-undangan, maka pernyataan batal tersebut tidak mengurangi keabsahan atau menyebabkan batalnya persyaratan atau ketentuan lain dalam akta ini dan oleh karenanya dalam hal demikian, persyaratan atau ketentuan lain dalam akta ini tetap sah dan mempunyai kekuatan mengikat diantara para pihak sebagaimana termuat dalam akta ini.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 16");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("1. Perjanjian ini dibuat dan diatur berdasarkan dan");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("menurut hukum Negara Republik Indonesia.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("2. Setiap perselisihan yang timbul sebagai akibat");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("dari pelaksanaan perjanjian ini akan diselesaikan secara musyarawah oleh para pihak.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("3. Apabila penyelesaian perselisihan tersebut diatas");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("tidak tercapai, maka para pihak sepakat untuk memilih domisili hukum yang tetap dan umum di Kantor Panitera Pengadilan Negeri Kota Depok.");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("4. Pemilihan domisili tersebut dilakukan dengan tidak");
        run.addTab();
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("mengurangi hak Penerima Fidusia dan/atau Kreditur untuk mengajukan tuntutan hukum terhadap Pemberi Fidusia berdasarkan perjanjian ini dihadapan Pengadilan Negeri lainnya dalam wilayah Negara Republik Indonesia, yaitu pada pengadilan Negeri yang mempunyai yuridiksi atas diri dari Pemberi Fidusia atau atas Obyek Jaminan Fidusia.");
        run.addTab();
        this.PasalJudul(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, "Pasal 17");
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Biaya-biaya yang berkenaan dengan pembuatan akta ini maupun dalam pelaksanaan ketentuan dalam akta ini menjadi tanggungan dan harus dibayar oleh Pemberi Fidusia, demikian pula biaya pendaftaran Jaminan Fidusia berdasarkan perjanjian ini di Kantor Pendaftaran Fidusia.");
        run.addTab();
    }

    public void TabelFormatText(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, int max, String judul, String text) {
        if (text.length() <= max) {
            XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
            XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(String.valueOf(judul) + " ");
            run = this.docx.huruf(paragraph, font_name, font_size);
            if (judul.toLowerCase().contains("nama")) {
                run.setBold(true);
            }
            run.setText(text);
            run = this.docx.huruf(paragraph, font_name, font_size);
            if (!judul.toLowerCase().contains("untuk")) {
                run.setText(";");
            }
            run.addTab();
        } else {
            XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 420, ktgr, rgb);
            XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText(String.valueOf(judul) + " ");
            String[][] nama = this.xhelp.KalimatPerBaris(max, text);
            int in = 0;
            while (in < nama.length) {
                if (nama[in][0] != null) {
                    if (in == 0) {
                        run = this.docx.huruf(paragraph, font_name, font_size);
                        if (judul.toLowerCase().contains("nama")) {
                            run.setBold(true);
                        }
                        run.setText(nama[in][1]);
                        run = this.docx.huruf(paragraph, font_name, font_size);
                        run.addTab();
                    } else if (in == nama.length - 1) {
                        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 3160, ktgr, rgb);
                        run = this.docx.huruf(paragraph, font_name, font_size);
                        if (judul.toLowerCase().contains("nama")) {
                            run.setBold(true);
                            run.setText(nama[in][1]);
                            run = this.docx.huruf(paragraph, font_name, font_size);
                            run.setText(";");
                            run.addTab();
                        } else {
                            run.setText(nama[in][1]);
                            run.setText(";");
                            run.addTab();
                        }
                    } else {
                        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 3160, ktgr, rgb);
                        run = this.docx.huruf(paragraph, font_name, font_size);
                        if (judul.toLowerCase().contains("nama")) {
                            run.setBold(true);
                            run.setText(nama[in][1]);
                            run = this.docx.huruf(paragraph, font_name, font_size);
                            run.addTab();
                        } else {
                            run.setText(nama[in][1]);
                            run.addTab();
                        }
                    }
                }
                ++in;
            }
        }
    }

    public void AkhirAkta(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String saksi1, String saksi2) {
        XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("------------------- ");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setBold(true);
        run.setText("DEMIKIANLAH AKTA INI");
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.addTab();
        run.addBreak();
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("- Dibuat sebagai minuta dan diselesaikan di Kota Bogor, pada hari, tanggal, bulan dan tahun seperti tersebut pada bagian awal akta ini, dengan dihadiri oleh :");
        run.addTab();
        this.SaksiAkta(document, spacing_before, spacing_after, spacing_between, bataskanan, ktgr, rgb, font_name, font_size, saksi1, saksi2);
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("Segera Setelah akta ini saya, Notaris, bacakan kepada para penghadap dan saksi-saksi, maka segera akta ini ditandatangani oleh para penghadap, para saksi saksi, dan saya, Notaris.");
        run.addTab();
    }

    public void SaksiAkta(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String saksi1, String saksi2) {
        XWPFRun run;
        XWPFParagraph paragraph;
        String[][] arr0 = this.saksi;
        int batas1 = 0;
        int ir1 = 0;
        while (ir1 < arr0.length) {
            if (arr0[ir1][0].equals(saksi1)) {
                paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
                run = this.docx.huruf(paragraph, font_name, font_size);
                run.setText("- ");
                run = this.docx.huruf(paragraph, font_name, font_size);
                run.setBold(true);
                run.setText(arr0[ir1][1]);
                batas1 = arr0[ir1][1].length() < 21 ? 40 : 20;
                run = this.docx.huruf(paragraph, font_name, font_size);
                run.setText(", " + arr0[ir1][2].substring(0, arr0[ir1][2].indexOf(" ", batas1) + 1));
                run.addTab();
                paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 180, ktgr, rgb);
                run = this.docx.huruf(paragraph, font_name, font_size);
                run.setText(arr0[ir1][2].substring(arr0[ir1][2].indexOf(" ", batas1) + 1, arr0[ir1][2].length()));
                run.setText(".");
                run.addTab();
            }
            ++ir1;
        }
        int batas2 = 0;
        int ir2 = 0;
        while (ir2 < arr0.length) {
            if (arr0[ir2][0].equals(saksi2)) {
                paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
                run = this.docx.huruf(paragraph, font_name, font_size);
                run.setText("- ");
                run = this.docx.huruf(paragraph, font_name, font_size);
                run.setBold(true);
                run.setText(arr0[ir2][1]);
                batas2 = arr0[ir2][1].length() < 21 ? 40 : 20;
                run = this.docx.huruf(paragraph, font_name, font_size);
                run.setText(", " + arr0[ir2][2].substring(0, arr0[ir2][2].indexOf(" ", batas2) + 1));
                run.addTab();
                paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 180, ktgr, rgb);
                run = this.docx.huruf(paragraph, font_name, font_size);
                run.setText(arr0[ir2][2].substring(arr0[ir2][2].indexOf(" ", batas2) + 1, arr0[ir2][2].length()));
                run.setText(".");
                run.addTab();
            }
            ++ir2;
        }
        paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
        run = this.docx.huruf(paragraph, font_name, font_size);
        run.setText("- Keduanya pegawai kantor saya, Notaris, sebagai saksi-saksi.");
        run.addTab();
    }

    public void TTDAkta(XWPFDocument document, int spacing_before, int spacing_after, double spacing_between, double bataskanan, String ktgr, String rgb, String font_name, int font_size, String ktgrprint, String saksi1, String saksi2, String bank, String cabang) throws Exception {
        if (ktgrprint.equals("salinan")) {
            XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
            XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("- Dilangsungkan dengan tanpa perubahan.");
            run.addTab();
            run.addBreak();
            run.setText("-Minuta Akta ini telah ditandatangani dengan sempurna.");
            run.addTab();
            run.addBreak();
            run.setText("-Diberikan sebagai salinan yang sama bunyinya.");
            run.addTab();
            paragraph = document.createParagraph();
            paragraph.setSpacingBefore(0);
            paragraph.setSpacingAfter(0);
            this.docx.createLineShape(paragraph, "bawah:-10", "#FF0000");
            this.docx.createLineShape(paragraph, "bawah:-12", "#FF0000");
            paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "tengah", 1200, "nogaris", rgb);
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("  NOTARIS KOTA BOGOR");
            run.addBreak();
            run.addBreak();
            run.addBreak();
            run.addBreak();
            run = this.docx.huruf(paragraph, font_name, font_size);
            run.setBold(true);
            run.setUnderline(UnderlinePatterns.SINGLE);
            run.setText("PUTRANTO NUR UTOMO, S.H., M.Kn.");
        } else {
            XWPFParagraph paragraph = this.docx.NotCreateParagraph(document, spacing_before, spacing_after, spacing_between, bataskanan, "both", 0, ktgr, rgb);
            XWPFRun run = this.docx.huruf(paragraph, font_name, font_size);
            run.setText("-Dilangsungkan dengan tanpa perubahan.");
            run.addTab();
            run.addBreak();
        }
    }
}

