/*
 * Decompiled with CFR 0.152.
 */
package xsatriya.xsf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import xsatriya.file.XSFile;
import xsatriya.help.XSHelp;
import xsatriya.xsf.Db;

public class LaporanBulanan {
    Db db = new Db();
    int x = 0;
    String qry = "";
    String hsl = "";
    String dbname = this.db.dbname();

    public static void main(String[] args) throws Exception {
        System.out.println("XSatriya");
        LaporanBulanan LB = new LaporanBulanan();
    }

    public void Properties(XSSFWorkbook workbook) {
        workbook.getProperties().getCoreProperties().setCreator("XSatriya");
        workbook.getProperties().getCoreProperties().setKeywords("XSatriya");
        workbook.getProperties().getCoreProperties().setTitle("Laporan Bulanan Fidusia");
        workbook.getProperties().getCoreProperties().setDescription("Laporan Bulanan Fidusia");
    }

    public void PageMargin(XSSFSheet spreadsheet) {
        spreadsheet.setMargin((short)1, 0.2);
        spreadsheet.setMargin((short)0, 0.2);
        spreadsheet.setMargin((short)2, 0.5);
        spreadsheet.setMargin((short)3, 0.5);
    }

    public XSSFCellStyle cellStyleHeader(XSSFWorkbook workbook) {
        XSSFFont fontBold = workbook.createFont();
        fontBold.setBold(true);
        XSSFCellStyle style = workbook.createCellStyle();
        style.setBorderTop(BorderStyle.MEDIUM);
        style.setBorderBottom(BorderStyle.MEDIUM);
        style.setBorderLeft(BorderStyle.MEDIUM);
        style.setBorderRight(BorderStyle.MEDIUM);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setFont((Font)fontBold);
        return style;
    }

    public XSSFCellStyle cellStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setBorderTop(BorderStyle.MEDIUM);
        style.setBorderBottom(BorderStyle.MEDIUM);
        style.setBorderLeft(BorderStyle.MEDIUM);
        style.setBorderRight(BorderStyle.MEDIUM);
        style.setWrapText(true);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setAlignment(HorizontalAlignment.CENTER);
        return style;
    }

    public void Header(XSSFWorkbook workbook, XSSFSheet spreadsheet, String nama, String kedudukan, String periode) {
        XSSFFont fontBold = workbook.createFont();
        fontBold.setBold(true);
        XSSFCellStyle style = workbook.createCellStyle();
        style.setWrapText(true);
        XSSFCellStyle style1 = workbook.createCellStyle();
        style1.setWrapText(true);
        style1.setAlignment(HorizontalAlignment.CENTER);
        style1.setFont((Font)fontBold);
        XSSFCellStyle style2 = workbook.createCellStyle();
        style2.setWrapText(true);
        style2.setAlignment(HorizontalAlignment.LEFT);
        style2.setFont((Font)fontBold);
        CellRangeAddress mergedRegion = new CellRangeAddress(5, 5, 3, 4);
        spreadsheet.addMergedRegion(mergedRegion);
        mergedRegion = new CellRangeAddress(6, 6, 3, 4);
        spreadsheet.addMergedRegion(mergedRegion);
        mergedRegion = new CellRangeAddress(8, 8, 1, 2);
        spreadsheet.addMergedRegion(mergedRegion);
        mergedRegion = new CellRangeAddress(8, 8, 3, 4);
        spreadsheet.addMergedRegion(mergedRegion);
        mergedRegion = new CellRangeAddress(9, 9, 1, 2);
        spreadsheet.addMergedRegion(mergedRegion);
        mergedRegion = new CellRangeAddress(9, 9, 3, 4);
        spreadsheet.addMergedRegion(mergedRegion);
        mergedRegion = new CellRangeAddress(12, 12, 0, 2);
        spreadsheet.addMergedRegion(mergedRegion);
        XSSFRow headerRow = spreadsheet.createRow(0);
        XSSFCell headerCell = headerRow.createCell(5);
        headerCell.setCellValue("LAMPIRAN\nSurat Kepala Kantor Wilayah");
        headerCell.setCellStyle((CellStyle)style);
        headerRow = spreadsheet.createRow(1);
        headerCell = headerRow.createCell(5);
        headerCell.setCellValue("Nomor   :");
        headerCell.setCellStyle((CellStyle)style);
        headerRow = spreadsheet.createRow(2);
        headerCell = headerRow.createCell(5);
        headerCell.setCellValue("Tanggal :");
        headerCell.setCellStyle((CellStyle)style);
        headerRow = spreadsheet.createRow(5);
        headerCell = headerRow.createCell(3);
        headerCell.setCellValue("FORMAT LAPORAN AKTA JAMINAN FIDUSIA YANG DIBUAT NOTARIS");
        headerCell.setCellStyle((CellStyle)style1);
        headerRow = spreadsheet.createRow(6);
        headerCell = headerRow.createCell(3);
        headerCell.setCellValue("PERIODE " + periode.toUpperCase());
        headerCell.setCellStyle((CellStyle)style1);
        headerRow = spreadsheet.createRow(8);
        headerCell = headerRow.createCell(1);
        headerCell.setCellValue("NAMA NOTARIS");
        headerCell.setCellStyle((CellStyle)style2);
        headerCell = headerRow.createCell(3);
        headerCell.setCellValue(": " + nama);
        headerCell.setCellStyle((CellStyle)style2);
        headerRow = spreadsheet.createRow(9);
        headerCell = headerRow.createCell(1);
        headerCell.setCellValue("KEDUDUKAN NOTARIS");
        headerCell.setCellStyle((CellStyle)style2);
        headerCell = headerRow.createCell(3);
        headerCell.setCellValue(": " + kedudukan);
        headerCell.setCellStyle((CellStyle)style2);
        headerRow = spreadsheet.createRow(12);
        headerCell = headerRow.createCell(0);
        headerCell.setCellValue("BULAN : " + periode);
        headerCell.setCellStyle((CellStyle)style2);
    }

    public void TableHeader(XSSFWorkbook workbook, XSSFSheet spreadsheet) {
        CellRangeAddress mergedRegion = new CellRangeAddress(13, 13, 3, 4);
        spreadsheet.addMergedRegion(mergedRegion);
        mergedRegion = new CellRangeAddress(13, 14, 0, 0);
        spreadsheet.addMergedRegion(mergedRegion);
        mergedRegion = new CellRangeAddress(13, 14, 1, 1);
        spreadsheet.addMergedRegion(mergedRegion);
        mergedRegion = new CellRangeAddress(13, 14, 2, 2);
        spreadsheet.addMergedRegion(mergedRegion);
        mergedRegion = new CellRangeAddress(13, 14, 5, 5);
        spreadsheet.addMergedRegion(mergedRegion);
        XSSFRow headerRow = spreadsheet.createRow(13);
        XSSFCell headerCell = headerRow.createCell(0);
        headerCell.setCellValue("No.");
        headerCell.setCellStyle((CellStyle)this.cellStyleHeader(workbook));
        CellUtil.setCellStyleProperty((Cell)headerCell, (String)"verticalAlignment", (Object)VerticalAlignment.CENTER);
        CellUtil.setCellStyleProperty((Cell)headerCell, (String)"alignment", (Object)HorizontalAlignment.CENTER);
        headerCell = headerRow.createCell(1);
        headerCell.setCellValue("Nomor Akta");
        headerCell.setCellStyle((CellStyle)this.cellStyleHeader(workbook));
        CellUtil.setCellStyleProperty((Cell)headerCell, (String)"verticalAlignment", (Object)VerticalAlignment.CENTER);
        CellUtil.setCellStyleProperty((Cell)headerCell, (String)"alignment", (Object)HorizontalAlignment.CENTER);
        headerCell = headerRow.createCell(2);
        headerCell.setCellValue("Tanggal Akta");
        headerCell.setCellStyle((CellStyle)this.cellStyleHeader(workbook));
        CellUtil.setCellStyleProperty((Cell)headerCell, (String)"verticalAlignment", (Object)VerticalAlignment.CENTER);
        CellUtil.setCellStyleProperty((Cell)headerCell, (String)"alignment", (Object)HorizontalAlignment.CENTER);
        headerCell = headerRow.createCell(3);
        headerCell.setCellValue("Para Pihak");
        headerCell.setCellStyle((CellStyle)this.cellStyleHeader(workbook));
        CellUtil.setCellStyleProperty((Cell)headerCell, (String)"alignment", (Object)HorizontalAlignment.CENTER);
        headerCell = headerRow.createCell(4);
        headerCell.setCellStyle((CellStyle)this.cellStyleHeader(workbook));
        headerCell = headerRow.createCell(5);
        headerCell.setCellValue("No. Sertifikat\nJaminan Fidusia\n(Jika Mendapat Kuasa Untuk Mendaftar)");
        headerCell.setCellStyle((CellStyle)this.cellStyleHeader(workbook));
        CellUtil.setCellStyleProperty((Cell)headerCell, (String)"verticalAlignment", (Object)VerticalAlignment.CENTER);
        CellUtil.setCellStyleProperty((Cell)headerCell, (String)"alignment", (Object)HorizontalAlignment.CENTER);
        XSSFRow headerRow1 = spreadsheet.createRow(14);
        XSSFCell headerCell1 = headerRow1.createCell(0);
        headerCell1.setCellStyle((CellStyle)this.cellStyleHeader(workbook));
        headerCell1 = headerRow1.createCell(1);
        headerCell1.setCellStyle((CellStyle)this.cellStyleHeader(workbook));
        headerCell1 = headerRow1.createCell(2);
        headerCell1.setCellStyle((CellStyle)this.cellStyleHeader(workbook));
        headerCell1 = headerRow1.createCell(3);
        headerCell1.setCellValue("Nama Pemberi Fidusia");
        headerCell1.setCellStyle((CellStyle)this.cellStyleHeader(workbook));
        CellUtil.setCellStyleProperty((Cell)headerCell1, (String)"alignment", (Object)HorizontalAlignment.CENTER);
        headerCell1 = headerRow1.createCell(4);
        headerCell1.setCellValue("Nama Penerima Fidusia & Tempat Kedudukan Provinsi");
        headerCell1.setCellStyle((CellStyle)this.cellStyleHeader(workbook));
        CellUtil.setCellStyleProperty((Cell)headerCell1, (String)"alignment", (Object)HorizontalAlignment.CENTER);
        headerCell1 = headerRow1.createCell(5);
        headerCell1.setCellStyle((CellStyle)this.cellStyleHeader(workbook));
        spreadsheet.setColumnWidth(0, 1280);
        spreadsheet.setColumnWidth(1, 2304);
        spreadsheet.setColumnWidth(2, 4608);
        spreadsheet.setColumnWidth(3, 7680);
        spreadsheet.setColumnWidth(4, 7680);
        spreadsheet.setColumnWidth(5, 8192);
    }

    public String create(String nmfolder, String lokf, String nama, String kedudukan, String th, String bl, JSONArray jsonArray) throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook();
        this.Properties(workbook);
        XSSFSheet spreadsheet = workbook.createSheet("Periode " + bl + "-" + th);
        spreadsheet.getPrintSetup().setPaperSize((short)9);
        this.PageMargin(spreadsheet);
        String periode = String.valueOf(new XSHelp().AngkaBulan(bl)) + " " + th;
        this.Header(workbook, spreadsheet, nama, kedudukan, periode);
        this.TableHeader(workbook, spreadsheet);
        Map<Integer, Object[]> lapData = this.MapData(jsonArray);
        Set<Integer> keyid = lapData.keySet();
        int rowid = 15;
        for (int key : keyid) {
            XSSFRow row = spreadsheet.createRow(rowid++);
            Object[] objectArr = lapData.get(key);
            int cellid = 0;
            Object[] objectArray = objectArr;
            int n = objectArr.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                XSSFCell cell = row.createCell(cellid++);
                cell.setCellStyle((CellStyle)this.cellStyle(workbook));
                cell.setCellValue((String)obj);
                ++n2;
            }
        }
        String fname = "LaporanFidusia-" + nama + "-" + th + "-" + bl;
        this.hsl = this.lokFile(workbook, lokf, nmfolder, fname);
        return this.hsl;
    }

    public Map<Integer, Object[]> MapData(JSONArray jsonArray) {
        TreeMap<Integer, Object[]> lapData = new TreeMap<Integer, Object[]>();
        int i = 0;
        while (i < jsonArray.size()) {
            JSONObject sonObject = (JSONObject)jsonArray.get(i);
            String nourut = (String)sonObject.get((Object)"nourut");
            String noakta = (String)sonObject.get((Object)"noakta");
            String tglakta = (String)sonObject.get((Object)"tglakta");
            String pemberi = (String)sonObject.get((Object)"pemberi");
            String penerima = (String)sonObject.get((Object)"penerima");
            String sertifikat = (String)sonObject.get((Object)"sertifikat");
            int ie = i + 1;
            lapData.put(ie, new Object[]{nourut, noakta, tglakta, pemberi, penerima, sertifikat});
            ++i;
        }
        return lapData;
    }

    public JSONArray Data() {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"nourut", (Object)"1");
        jsonObject.put((Object)"noakta", (Object)"1");
        jsonObject.put((Object)"tglakta", (Object)"20 Mei 2025");
        jsonObject.put((Object)"pemberi", (Object)"Abimanyu");
        jsonObject.put((Object)"penerima", (Object)"PT CAPELLA MULTIDANA, Provinsi Sumatera Utara");
        jsonObject.put((Object)"sertifikat", (Object)"W2.00113379.AH.05.01 Tahun 2025");
        jsonArray.add((Object)jsonObject);
        JSONObject jsonObject1 = new JSONObject();
        jsonObject1.put((Object)"nourut", (Object)"2");
        jsonObject1.put((Object)"noakta", (Object)"2000");
        jsonObject1.put((Object)"tglakta", (Object)"21 September 2025");
        jsonObject1.put((Object)"pemberi", (Object)"Ananda");
        jsonObject1.put((Object)"penerima", (Object)"PT CAPELLA MULTIDANA, Provinsi Sumatera Utara");
        jsonObject1.put((Object)"sertifikat", (Object)"W2.00113379.AH.05.01 Tahun 2025");
        jsonArray.add((Object)jsonObject1);
        return jsonArray;
    }

    public String lokFile(XSSFWorkbook workbook, String lokf, String nmfolder, String fname) throws IOException, ClassNotFoundException {
        String lok = "xsaf\\download\\" + nmfolder + "\\";
        String lok1 = "/xsaf/download/" + nmfolder + "/";
        String lokfile = String.valueOf(lokf) + lok;
        new XSFile().createDir(lokfile);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(String.valueOf(lokfile) + "\\" + fname + ".xlsx"));
            workbook.write((OutputStream)out);
            out.close();
            this.hsl = String.valueOf(lok1) + "/" + fname + ".xlsx";
        }
        catch (Exception e) {
            System.out.println("Cannot Execute Properly");
        }
        return this.hsl;
    }

    public String tglIndo(String tg) {
        String[] dateParts = tg.split("/");
        String t1 = dateParts[0];
        String t2 = dateParts[1];
        String t3 = dateParts[2];
        String tgl = String.valueOf(t1) + " " + new XSHelp().AngkaBulan(t2) + " " + t3;
        return tgl;
    }
}

