/*
 * Decompiled with CFR 0.152.
 */
package xsatriya.print;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;

public class ThermalPrinter
implements Printable {
    public List<String> getPrinters() {
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(flavor, pras);
        ArrayList<String> printerList = new ArrayList<String>();
        PrintService[] printServiceArray = printServices;
        int n = printServices.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService printerService = printServiceArray[n2];
            printerList.add(printerService.getName());
            ++n2;
        }
        return printerList;
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        g.setFont(new Font("Roman", 0, 8));
        g.drawString("Hello world !", 0, 10);
        return 0;
    }

    public void printString(String printerName, String text) {
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        PrintService[] printService = PrintServiceLookup.lookupPrintServices(flavor, pras);
        PrintService service = this.findPrintService(printerName, printService);
        DocPrintJob job = service.createPrintJob();
        try {
            byte[] bytes = text.getBytes("CP437");
            SimpleDoc doc = new SimpleDoc(bytes, flavor, null);
            job.print(doc, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printBytes(String printerName, byte[] bytes) {
        DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.AUTOSENSE;
        HashPrintRequestAttributeSet pras = new HashPrintRequestAttributeSet();
        PrintService[] printService = PrintServiceLookup.lookupPrintServices(flavor, pras);
        PrintService service = this.findPrintService(printerName, printService);
        DocPrintJob job = service.createPrintJob();
        try {
            SimpleDoc doc = new SimpleDoc(bytes, flavor, null);
            job.print(doc, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PrintService findPrintService(String printerName, PrintService[] services) {
        PrintService[] printServiceArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService service = printServiceArray[n2];
            if (service.getName().equalsIgnoreCase(printerName)) {
                return service;
            }
            ++n2;
        }
        return null;
    }
}

