/*
 * Decompiled with CFR 0.152.
 */
package xsatriya.print;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import xsatriya.print.MainTable;

public class PrintSupport {
    static JTable itemsTable;
    public static int total_item_count;
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss a";
    public static String[] title;

    static {
        total_item_count = 0;
        title = new String[]{"Item Name", "Quantity", "Price", "Jumlah"};
    }

    public static void setItems(Object[][] printitem) {
        Object[][] data = printitem;
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn(title[0]);
        model.addColumn(title[1]);
        model.addColumn(title[2]);
        model.addColumn(title[3]);
        int rowcount = printitem.length;
        PrintSupport.addtomodel(model, data, rowcount);
        itemsTable = new JTable(model);
    }

    public static void addtomodel(DefaultTableModel model, Object[][] data, int rowcount) {
        int count = 0;
        while (count < rowcount) {
            model.addRow(data[count]);
            ++count;
        }
        if (model.getRowCount() != rowcount) {
            PrintSupport.addtomodel(model, data, rowcount);
        }
        System.out.println("Check Passed.");
    }

    public Object[][] getTableData(JTable table) {
        int itemcount = table.getRowCount();
        System.out.println("Item Count:" + itemcount);
        DefaultTableModel dtm = (DefaultTableModel)table.getModel();
        int nRow = dtm.getRowCount();
        int nCol = dtm.getColumnCount();
        Object[][] tableData = new Object[nRow][nCol];
        if (itemcount == nRow) {
            int i = 0;
            while (i < nRow) {
                int j = 0;
                while (j < nCol) {
                    tableData[i][j] = dtm.getValueAt(i, j);
                    ++j;
                }
                ++i;
            }
            if (tableData.length != itemcount) {
                this.getTableData(table);
            }
            System.out.println("Data check passed");
        } else {
            this.getTableData(table);
        }
        return tableData;
    }

    public static PageFormat getPageFormat(PrinterJob pj) {
        PageFormat pf = pj.defaultPage();
        Paper paper = pf.getPaper();
        double middleHeight = (double)total_item_count * 1.0;
        double headerHeight = 5.0;
        double footerHeight = 5.0;
        double width = PrintSupport.convert_CM_To_PPI(7.0);
        double height = PrintSupport.convert_CM_To_PPI(headerHeight + middleHeight + footerHeight);
        paper.setSize(width, height);
        paper.setImageableArea(PrintSupport.convert_CM_To_PPI(0.25), PrintSupport.convert_CM_To_PPI(0.5), width - PrintSupport.convert_CM_To_PPI(0.35), height - PrintSupport.convert_CM_To_PPI(1.0));
        pf.setOrientation(1);
        pf.setPaper(paper);
        return pf;
    }

    protected static double convert_CM_To_PPI(double cm) {
        return PrintSupport.toPPI(cm * 0.393600787);
    }

    protected static double toPPI(double inch) {
        return inch * 72.0;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    public static void main(String[] args) {
        String[][] produk = new String[][]{{"Makanan", "1", "3.000", "3.000"}, {"Minuman", "2", "9.000", "18.000"}, {"Susu", "1", "159.000", "159.000"}};
        MainTable mt = new MainTable();
        PrintSupport ps = new PrintSupport();
        Object[] columns = new String[]{"Item Name", "Quantity", "Price", "Jumlah"};
        Object[][] data = new Object[][]{{"John", "1", "40000", "40000"}, {"Rambo", "2", "70000", "140000"}, {"Zorro", "1", "60000", "60000"}};
        JTable table = new JTable(data, columns);
        Object[][] printitem = ps.getTableData(table);
        PrintSupport.setItems(printitem);
        PrinterJob pj = PrinterJob.getPrinterJob();
        MainTable.MyPrintable mp = mt.new MainTable.MyPrintable();
        pj.setPrintable(mp, PrintSupport.getPageFormat(pj));
        try {
            pj.print();
        }
        catch (PrinterException ex) {
            ex.printStackTrace();
        }
    }

    public JTable TableExample() {
        Object[] columns = new String[]{"Item Name", "Quantity", "Price", "Jumlah"};
        JFrame f = new JFrame();
        Object[][] data = new Object[][]{{"John", "1", "40.000", "40.000"}, {"Rambo", "2", "70.000", "140.000"}, {"Zorro", "1", "60.000", "60.000"}};
        DefaultTableModel model = new DefaultTableModel(data, columns);
        JTable table = new JTable();
        table.setModel(model);
        return table;
    }

    public class MyPrintable
    implements Printable {
        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            int result = 1;
            if (pageIndex == 0) {
                Graphics2D g2d = (Graphics2D)graphics;
                double width = pageFormat.getImageableWidth();
                double height = pageFormat.getImageableHeight();
                g2d.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
                Font font = new Font("Monospaced", 0, 7);
                g2d.setFont(font);
                try {
                    int x = 100;
                    int y = 10;
                    int imagewidth = 100;
                    int imageheight = 50;
                    BufferedImage read = ImageIO.read(this.getClass().getResource("/image/logo.gif"));
                    g2d.drawImage(read, x, y, imagewidth, imageheight, null);
                    g2d.drawLine(10, y + 60, 180, y + 60);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    int y = 80;
                    g2d.drawString("ABC Shopping Complex", 40, y);
                    g2d.drawString("CopyWrite 2009-2014", 50, y + 10);
                    g2d.drawString(PrintSupport.now(), 10, y + 20);
                    g2d.drawString("Cashier : admin", 10, y + 30);
                    g2d.drawLine(10, y + 40, 180, y + 40);
                    g2d.drawString(title[0], 10, y + 50);
                    g2d.drawString(title[1], 50, y + 50);
                    g2d.drawString(title[2], 100, y + 50);
                    g2d.drawString(title[3], 150, y + 50);
                    g2d.drawLine(10, y + 60, 180, y + 60);
                    int cH = 0;
                    TableModel mod = itemsTable.getModel();
                    int i = 0;
                    while (i < mod.getRowCount()) {
                        String itemid = mod.getValueAt(i, 0).toString();
                        String itemname = mod.getValueAt(i, 1).toString();
                        String price = mod.getValueAt(i, 2).toString();
                        String quantity = mod.getValueAt(i, 3).toString();
                        cH = y + 70 + 10 * i;
                        g2d.drawString(itemid, 0, cH);
                        g2d.drawString(itemname, 50, cH);
                        g2d.drawString(price, 100, cH);
                        g2d.drawString(quantity, 150, cH);
                        ++i;
                    }
                    font = new Font("Arial", 1, 16);
                    g2d.setFont(font);
                    g2d.drawString("Thank You Come Again", 30, cH + 10);
                }
                catch (Exception r) {
                    r.printStackTrace();
                }
                result = 0;
            }
            return result;
        }
    }
}

