/*
 * Decompiled with CFR 0.152.
 */
package xsatriya.print;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.imageio.ImageIO;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import xsatriya.print.PrintSupport;

public class MainTable {
    public static String[] title = new String[]{"Item Name", "Price", "Quantity", "Jumlah"};
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss a";
    static JTable itemsTable;

    public static void main(String[] args) {
        String[][] produk = new String[][]{{"Makanan", "1", "3.000", "3.000"}, {"Minuman", "2", "9.000", "18.000"}, {"Susu", "1", "159.000", "159.000"}};
        MainTable mt = new MainTable();
        PrintSupport ps = new PrintSupport();
        Object[][] printitem = ps.getTableData(mt.TableExample());
        PrintSupport.setItems(printitem);
        PrinterJob pj = PrinterJob.getPrinterJob();
        MyPrintable mp = mt.new MyPrintable();
        pj.setPrintable(mp, PrintSupport.getPageFormat(pj));
        try {
            pj.print();
        }
        catch (PrinterException ex) {
            ex.printStackTrace();
        }
    }

    public JTable TableExample() {
        Object[] columns = new String[]{"Item", "Qty", "Harga", "Jumlah"};
        Object[][] data = new Object[][]{{"John", "1", "40.000", "40.000"}, {"Rambo", "2", "70.000", "140.000"}, {"Zorro", "1", "60.000", "60.000"}};
        JTable table = new JTable(data, columns);
        return table;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    public class MyPrintable
    implements Printable {
        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            int result = 1;
            if (pageIndex == 0) {
                Graphics2D g2d = (Graphics2D)graphics;
                double width = pageFormat.getImageableWidth();
                double height = pageFormat.getImageableHeight();
                g2d.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
                Font font = new Font("Monospaced", 0, 7);
                g2d.setFont(font);
                try {
                    int x = 100;
                    int y = 10;
                    int imagewidth = 100;
                    int imageheight = 50;
                    BufferedImage read = ImageIO.read(this.getClass().getResource("/image/logo.gif"));
                    g2d.drawImage(read, x, y, imagewidth, imageheight, null);
                    g2d.drawLine(10, y + 60, 180, y + 60);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    int y = 80;
                    g2d.drawString("ABC Shopping Complex", 40, y);
                    g2d.drawString("CopyWrite 2009-2014", 50, y + 10);
                    g2d.drawString(MainTable.now(), 10, y + 20);
                    g2d.drawString("Cashier : admin", 10, y + 30);
                    g2d.drawLine(10, y + 40, 180, y + 40);
                    g2d.drawString(title[0], 10, y + 50);
                    g2d.drawString(title[1], 50, y + 50);
                    g2d.drawString(title[2], 100, y + 50);
                    g2d.drawString(title[3], 150, y + 50);
                    g2d.drawLine(10, y + 60, 180, y + 60);
                    int cH = 0;
                    TableModel mod = itemsTable.getModel();
                    int i = 0;
                    while (i < mod.getRowCount()) {
                        String itemid = mod.getValueAt(i, 0).toString();
                        String itemname = mod.getValueAt(i, 1).toString();
                        String price = mod.getValueAt(i, 2).toString();
                        String quantity = mod.getValueAt(i, 3).toString();
                        cH = y + 70 + 10 * i;
                        g2d.drawString(itemid, 0, cH);
                        g2d.drawString(itemname, 50, cH);
                        g2d.drawString(price, 100, cH);
                        g2d.drawString(quantity, 150, cH);
                        ++i;
                    }
                    font = new Font("Arial", 1, 16);
                    g2d.setFont(font);
                    g2d.drawString("Thank You Come Again", 30, cH + 10);
                }
                catch (Exception r) {
                    r.printStackTrace();
                }
                result = 0;
            }
            return result;
        }
    }
}

