/*
 * Decompiled with CFR 0.152.
 */
package xsatriya.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import javax.imageio.ImageIO;

public class XSQRCode {
    private static Color c;

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        System.out.println("XSatriya");
        String myCodeText = "XSatriya.net";
        String namaFile = "xsqrcode";
    }

    static void create(String myCodeText, String namaFile, String namaFolder) throws IOException, ClassNotFoundException {
        int size = 250;
        String fileType = "png";
        File myFile = new File(String.valueOf(namaFolder) + "/" + namaFile + ".png");
        try {
            EnumMap<EncodeHintType, Object> hintMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
            hintMap.put(EncodeHintType.CHARACTER_SET, (Object)"UTF-8");
            hintMap.put(EncodeHintType.MARGIN, (Object)1);
            hintMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.L);
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix byteMatrix = qrCodeWriter.encode(myCodeText, BarcodeFormat.QR_CODE, size, size, hintMap);
            int CrunchifyWidth = byteMatrix.getWidth();
            BufferedImage image = new BufferedImage(CrunchifyWidth, CrunchifyWidth, 1);
            image.createGraphics();
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, CrunchifyWidth, CrunchifyWidth);
            graphics.setColor(Color.BLACK);
            int i = 0;
            while (i < CrunchifyWidth) {
                int j = 0;
                while (j < CrunchifyWidth) {
                    if (byteMatrix.get(i, j)) {
                        graphics.fillRect(i, j, 1, 1);
                    }
                    ++j;
                }
                ++i;
            }
            ImageIO.write((RenderedImage)image, fileType, myFile);
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

