/*
 * Decompiled with CFR 0.152.
 */
package xsatriya.jawa;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import xsatriya.jawa.Puasa;

public class Kalender {
    public static void main(String[] args) throws ParseException {
        Kalender kal = new Kalender();
        JSONArray jsonArray = kal.DinoCustom(2025, 5);
        System.out.println("JSON created: " + jsonArray);
        System.out.println("JSON size: " + jsonArray.size());
        int i = 0;
        while (i < jsonArray.size()) {
            JSONObject sonObject = (JSONObject)jsonArray.get(i);
            int thn = (Integer)sonObject.get((Object)"thn");
            int bln = (Integer)sonObject.get((Object)"bln");
            int tgl = (Integer)sonObject.get((Object)"tgl");
            int hari = (Integer)sonObject.get((Object)"hari");
            int pasaran = (Integer)sonObject.get((Object)"pasaran");
            String pasarannama = (String)sonObject.get((Object)"pasarannama");
            int naptu = (Integer)sonObject.get((Object)"naptu");
            String hitungmati = (String)sonObject.get((Object)"hitungmati");
            String warnamati = (String)sonObject.get((Object)"warnamati");
            String hitungbeli = (String)sonObject.get((Object)"hitungbeli");
            String warnabeli = (String)sonObject.get((Object)"warnabeli");
            String puasanaptu = (String)sonObject.get((Object)"puasanaptu");
            String puasalahir = (String)sonObject.get((Object)"puasalahir");
            System.out.println(String.valueOf(tgl) + "." + bln + "." + thn + " - " + hari + " - " + pasarannama + "(" + pasaran + ") - " + naptu + " - " + hitungmati + "(" + warnamati + ") - " + hitungbeli + "(" + warnabeli + ") - " + puasanaptu + " - " + puasalahir);
            ++i;
        }
    }

    public JSONArray DinoCustom(int thn, int bln) throws ParseException {
        JSONArray jsonArray = new JSONArray();
        int akhir = this.TglAkhir(thn, bln);
        int i = 1;
        while (i <= akhir) {
            JSONObject jsonObject = this.ObjDino(this.DinoCustom(thn, bln, i));
            jsonArray.add((Object)jsonObject);
            ++i;
        }
        return jsonArray;
    }

    public JSONArray Dino() {
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject = this.ObjDino(this.DinoSaiki());
        jsonArray.add((Object)jsonObject);
        JSONObject jsonObject1 = this.ObjDino(this.DinoSesok(1));
        jsonArray.add((Object)jsonObject1);
        JSONObject jsonObject2 = this.ObjDino(this.DinoSesok(2));
        jsonArray.add((Object)jsonObject2);
        JSONObject jsonObject3 = this.ObjDino(this.DinoSesok(3));
        jsonArray.add((Object)jsonObject3);
        JSONObject jsonObject4 = this.ObjDino(this.DinoSesok(4));
        jsonArray.add((Object)jsonObject4);
        JSONObject jsonObject5 = this.ObjDino(this.DinoSesok(5));
        jsonArray.add((Object)jsonObject5);
        JSONObject jsonObject6 = this.ObjDino(this.DinoSesok(6));
        jsonArray.add((Object)jsonObject6);
        return jsonArray;
    }

    public JSONObject ObjDino(int[] hr) {
        Puasa poso = new Puasa();
        String harinama = this.HariNama(hr[3]);
        String pasarnama = this.PasaranNama(hr[4]);
        String hitungmati = this.HitungMati(hr[5]);
        String hitungbeli = this.HitungBeli(hr[5]);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"thn", (Object)hr[0]);
        jsonObject.put((Object)"bln", (Object)hr[1]);
        jsonObject.put((Object)"tgl", (Object)hr[2]);
        jsonObject.put((Object)"hari", (Object)hr[3]);
        jsonObject.put((Object)"pasaran", (Object)hr[4]);
        jsonObject.put((Object)"pasarannama", (Object)pasarnama);
        jsonObject.put((Object)"naptu", (Object)hr[5]);
        jsonObject.put((Object)"hitungmati", (Object)hitungmati);
        jsonObject.put((Object)"warnamati", (Object)this.warnaMati(hitungmati));
        jsonObject.put((Object)"hitungbeli", (Object)hitungbeli);
        jsonObject.put((Object)"warnabeli", (Object)this.warnaBeli(hitungbeli));
        jsonObject.put((Object)"puasanaptu", (Object)poso.PuasaNaptu(harinama, pasarnama));
        jsonObject.put((Object)"puasalahir", (Object)poso.PuasaLahir(harinama, pasarnama));
        jsonObject.put((Object)"pager", (Object)this.Pager(harinama, pasarnama));
        return jsonObject;
    }

    public int[] DinoCustom(int thn, int bln, int tgl) throws ParseException {
        int[] lic = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        Date mydate = dateFormat.parse(String.valueOf(tgl) + "/" + bln + "/" + thn);
        Calendar cal = Calendar.getInstance();
        cal.setTime(mydate);
        int hari = cal.get(7);
        int hitung = this.Hitung(tgl, bln, thn);
        int pasaran = this.Pasaran(hitung);
        int naptuhari = this.NaptuHari(this.HariNama(hari));
        int naptupasaran = this.NaptuPasaran(this.PasaranNama(pasaran));
        int naptu = naptuhari + naptupasaran;
        lic = new int[]{thn, bln, tgl, hari, pasaran, naptu};
        return lic;
    }

    public int[] DinoSaiki() {
        int[] lic = null;
        GregorianCalendar cal = new GregorianCalendar();
        int thn = cal.get(1);
        int bln = cal.get(2) + 1;
        int tgl = cal.get(5);
        int hari = cal.get(7);
        int hitung = this.Hitung(tgl, bln, thn);
        int pasaran = this.Pasaran(hitung);
        int naptuhari = this.NaptuHari(this.HariNama(hari));
        int naptupasaran = this.NaptuPasaran(this.PasaranNama(pasaran));
        int naptu = naptuhari + naptupasaran;
        lic = new int[]{thn, bln, tgl, hari, pasaran, naptu};
        return lic;
    }

    public int[] DinoSesok(int hr) {
        int[] lic = null;
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(6, hr);
        int thn = cal.get(1);
        int bln = cal.get(2) + 1;
        int tgl = cal.get(5);
        int hari = cal.get(7);
        int hitung = this.Hitung(tgl, bln, thn);
        int pasaran = this.Pasaran(hitung);
        int naptuhari = this.NaptuHari(this.HariNama(hari));
        int naptupasaran = this.NaptuPasaran(this.PasaranNama(pasaran));
        int naptu = naptuhari + naptupasaran;
        lic = new int[]{thn, bln, tgl, hari, pasaran, naptu};
        return lic;
    }

    public boolean isLeapYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        return cal.getActualMaximum(6) > 365;
    }

    public int Hitung(int itgl, int ibln, int ithn) {
        int jt = (ithn - 1) / 4;
        int jt1 = (ithn - 1) % 4;
        int jt2 = jt * 1461 + jt1 * 365;
        int jb = ibln - 1;
        int jh = jb == 1 ? 31 : (jb == 2 ? (this.isLeapYear(ithn) ? 60 : 59) : (jb == 3 ? 90 : (jb == 4 ? 120 : (jb == 5 ? 151 : (jb == 6 ? 180 : (jb == 7 ? 212 : (jb == 8 ? 243 : (jb == 9 ? 273 : (jb == 10 ? 304 : (jb == 11 ? 334 : 0))))))))));
        int jg = itgl;
        int j = jt2 + jh + jg - 13;
        return j;
    }

    public int Pasaran(int hitung) {
        int p = hitung % 5;
        return p;
    }

    public String HariNama(int ihr) {
        String hr = ihr == 1 ? "Minggu" : (ihr == 2 ? "Senin" : (ihr == 3 ? "Selasa" : (ihr == 4 ? "Rabu" : (ihr == 5 ? "Kamis" : (ihr == 6 ? "Jumat" : "Sabtu")))));
        return hr;
    }

    public String PasaranNama(int inp) {
        String p = inp == 1 ? "Kliwon" : (inp == 2 ? "Legi" : (inp == 3 ? "Pahing" : (inp == 4 ? "Pon" : "Wage")));
        return p;
    }

    public int NaptuHari(String hari) {
        int naptu;
        switch (hari = hari.toLowerCase()) {
            case "sabtu": {
                naptu = 9;
                break;
            }
            case "minggu": {
                naptu = 5;
                break;
            }
            case "senin": {
                naptu = 4;
                break;
            }
            case "selasa": {
                naptu = 3;
                break;
            }
            case "rabu": {
                naptu = 7;
                break;
            }
            case "kamis": {
                naptu = 8;
                break;
            }
            case "jumat": {
                naptu = 6;
                break;
            }
            default: {
                naptu = 6;
            }
        }
        return naptu;
    }

    public int NaptuPasaran(String pasaran) {
        int naptu;
        switch (pasaran = pasaran.toLowerCase()) {
            case "kliwon": {
                naptu = 8;
                break;
            }
            case "legi": {
                naptu = 5;
                break;
            }
            case "pahing": {
                naptu = 9;
                break;
            }
            case "pon": {
                naptu = 7;
                break;
            }
            case "wage": {
                naptu = 4;
                break;
            }
            default: {
                naptu = 4;
            }
        }
        return naptu;
    }

    public String HitungMati(int n) {
        String mt = n % 4 == 1 ? "Gunung" : (n % 4 == 2 ? "Guntur" : (n % 4 == 3 ? "Segoro" : "Asat"));
        return mt;
    }

    public String HitungBeli(int n) {
        String mt = n % 4 == 1 ? "Guru" : (n % 4 == 2 ? "Ratu" : (n % 4 == 3 ? "Rogoh" : "Sempoyong"));
        return mt;
    }

    public int HariAwal(int thn, int bln) {
        GregorianCalendar cal = new GregorianCalendar(thn, bln - 1, 1);
        int hari = cal.get(7);
        return hari;
    }

    public int TglAkhir(int thn, int bln) {
        GregorianCalendar cal = new GregorianCalendar(thn, bln - 1, 1);
        int res = cal.getActualMaximum(5);
        return res;
    }

    public String warnaKolom(int tgl, int tglskrg, int posisi) {
        String wrn = "";
        wrn = tgl == tglskrg ? "info" : (posisi % 7 == 1 ? "danger" : (posisi % 7 == 6 ? "success" : ""));
        return wrn;
    }

    public String warnaMati(String nama) {
        String hsl;
        switch (nama = nama.toLowerCase()) {
            case "gunung": {
                hsl = "success";
                break;
            }
            case "guntur": {
                hsl = "danger";
                break;
            }
            case "segoro": {
                hsl = "success";
                break;
            }
            case "asat": {
                hsl = "danger";
                break;
            }
            default: {
                hsl = "success";
            }
        }
        return hsl;
    }

    public String warnaBeli(String nama) {
        String hsl;
        switch (nama = nama.toLowerCase()) {
            case "guru": {
                hsl = "success";
                break;
            }
            case "ratu": {
                hsl = "success";
                break;
            }
            case "rogoh": {
                hsl = "danger";
                break;
            }
            case "sempoyong": {
                hsl = "danger";
                break;
            }
            default: {
                hsl = "success";
            }
        }
        return hsl;
    }

    public String Pager(String hari, String pasar) {
        hari = hari.toLowerCase();
        pasar = pasar.toLowerCase();
        String hsl = hari.equals("rabu") && pasar.equals("pon") ? "pager" : (hari.equals("jumat") && pasar.equals("kliwon") ? "pager" : (hari.equals("sabtu") && pasar.equals("legi") ? "pager" : (hari.equals("minggu") && pasar.equals("pahing") ? "pager" : "")));
        return hsl;
    }
}

